/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.activeobjects.daos;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.CacheLoader;
import com.atlassian.confluence.spaces.Space;
import com.cenotelabs.lockpoint.a;
import com.cenotelabs.lockpoint.activeobjects.entities.TemplateEntity;
import com.cenotelabs.lockpoint.activeobjects.models.Template;
import com.cenotelabs.lockpoint.f;
import net.java.ao.DBParam;
import org.springframework.stereotype.Component;

@Component
public class TemplateDao
extends a<TemplateEntity> {
    private final TemplateEntity NULL_ENTITY = this.createNullEntity(TemplateEntity.class);

    @Override
    protected TemplateEntity getNullEntity() {
        return this.NULL_ENTITY;
    }

    @Override
    public CacheLoader<String, TemplateEntity> getCacheLoader(ActiveObjects activeObjects) {
        return object2 -> {
            object2 = this.getSpaceIdQuery(TemplateDao.cacheKeyToSpaceId((String)object2), Template.Type.valueOf(TemplateDao.cacheKeyToType((String)object2)), TemplateDao.cacheKeyToLanguage((String)object2));
            ActiveObjects activeObjects = activeObjects;
            activeObjects = (TemplateEntity)this.enforceUnique(activeObjects, (TemplateEntity[])activeObjects.find(TemplateEntity.class, ((f)object2).a(), ((f)object2).b()));
            if (activeObjects == null) {
                return this.NULL_ENTITY;
            }
            return activeObjects;
        };
    }

    private TemplateEntity getRaw(ActiveObjects object, Space space, Template.Type type, String string) {
        if ((object = (TemplateEntity)this.getCache((ActiveObjects)object).get((Object)TemplateDao.paramsToCacheKey(space, type.toString(), string))) == this.NULL_ENTITY) {
            return null;
        }
        return object;
    }

    public Template get(ActiveObjects object, Space space, Template.Type type, String string) {
        if ((object = this.getRaw((ActiveObjects)object, space, type, string)) == null) {
            return null;
        }
        return new Template(space, Enum.valueOf(Template.Format.class, object.getFormat()), Enum.valueOf(Template.Type.class, object.getType()), object.getLanguage(), object.getSubject(), object.getBody());
    }

    public void save(ActiveObjects activeObjects, Template template) {
        try {
            TemplateEntity templateEntity = this.getRaw(activeObjects, template.getSpace(), template.getType(), template.getLanguage());
            if (templateEntity != null) {
                templateEntity.setFormat(template.getFormat().toString());
                templateEntity.setSubject(template.getSubject());
                templateEntity.setBody(template.getBody());
                templateEntity.save();
                return;
            }
            templateEntity = (TemplateEntity)activeObjects.create(TemplateEntity.class, new DBParam[]{new DBParam("SPACE_ID", (Object)TemplateDao.spaceToId(template.getSpace())), new DBParam("FORMAT", (Object)template.getFormat().toString()), new DBParam("TYPE", (Object)template.getType().toString()), new DBParam("LANGUAGE", (Object)template.getLanguage()), new DBParam("SUBJECT", (Object)template.getSubject()), new DBParam("BODY", (Object)template.getBody())});
            templateEntity.save();
            return;
        }
        finally {
            this.invalidateCache(activeObjects, template.getSpace(), template.getType(), template.getLanguage());
        }
    }

    public void delete(ActiveObjects activeObjects, Space space, Template.Type type, String string) {
        f f2 = this.getSpaceIdQuery(space, type, string);
        activeObjects.deleteWithSQL(TemplateEntity.class, f2.a(), f2.b());
        this.invalidateCache(activeObjects, space, type, string);
    }

    private void invalidateCache(ActiveObjects activeObjects, Space space, Template.Type type, String string) {
        this.getCache(activeObjects).remove((Object)TemplateDao.paramsToCacheKey(space, type.toString(), string));
    }

    private f getSpaceIdQuery(Space space, Template.Type type, String string) {
        return this.getSpaceIdQuery(TemplateDao.spaceToId(space), type, string);
    }

    private f getSpaceIdQuery(Long object, Template.Type object2, String objectArray) {
        object = this.getSpaceIdQuery((Long)object, object2.toString());
        if (objectArray == null) {
            object2 = "AND LANGUAGE IS NULL";
            objectArray = new Object[]{};
        } else {
            object2 = "AND LANGUAGE = ?";
            objectArray = new Object[]{objectArray};
        }
        ((f)object).a((String)object2, objectArray);
        return object;
    }

    protected static String paramsToCacheKey(Space space, String string, String string2) {
        return TemplateDao.paramsToCacheKey(space, string) + ":" + TemplateDao.languageToCacheKey(string2);
    }
}

