/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.webdav;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.cenotelabs.lockpoint.B;
import com.cenotelabs.lockpoint.ac;
import com.cenotelabs.lockpoint.ad;
import com.cenotelabs.lockpoint.ae;
import com.cenotelabs.lockpoint.lifecycle.PluginState;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import com.cenotelabs.lockpoint.webdav.WebDavAuthenticationManager;
import com.cenotelabs.lockpoint.webdav.WebDavUtil;
import com.cenotelabs.lockpoint.webdav.methods.CopyHandler;
import com.cenotelabs.lockpoint.webdav.methods.LockHandler;
import com.cenotelabs.lockpoint.webdav.methods.MoveHandler;
import com.cenotelabs.lockpoint.webdav.methods.UnlockHandler;
import com.cenotelabs.lockpoint.webdav.methods.WebDavHandlerParams;
import com.cenotelabs.lockpoint.webdav.methods.WebDavMethodHandler;
import com.cenotelabs.lockpoint.webdav.methods.WebDavModifyingAndHeaderCheckingMethodHandler;
import com.cenotelabs.lockpoint.webdav.methods.WebDavModifyingMethodHandler;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@UnrestrictedAccess
public class WebDavFilter
implements Filter {
    private static final Logger a = LoggerFactory.getLogger(WebDavFilter.class);
    private final WebDavAuthenticationManager b;
    private final WebDavUtil c;
    private final PluginState d;
    private final UserAccessor e;
    private final SpaceAttributesManager f;
    private final LockHandler g;
    private final MoveHandler h;
    private final UnlockHandler i;
    private final CopyHandler j;
    private final WebDavModifyingMethodHandler k;
    private final WebDavModifyingAndHeaderCheckingMethodHandler l;
    private Map<String, WeakReference<Object>> m = new HashMap<String, WeakReference<Object>>();

    @Inject
    public WebDavFilter(WebDavUtil webDavUtil, @ComponentImport UserAccessor userAccessor, SpaceAttributesManager spaceAttributesManager, PluginState pluginState, WebDavAuthenticationManager webDavAuthenticationManager, LockHandler lockHandler, MoveHandler moveHandler, UnlockHandler unlockHandler, CopyHandler copyHandler, @Qualifier(value="webDavModifyingMethodHandler") WebDavModifyingMethodHandler webDavModifyingMethodHandler, WebDavModifyingAndHeaderCheckingMethodHandler webDavModifyingAndHeaderCheckingMethodHandler) {
        this.c = webDavUtil;
        this.e = userAccessor;
        this.f = spaceAttributesManager;
        this.d = pluginState;
        this.b = webDavAuthenticationManager;
        this.g = lockHandler;
        this.h = moveHandler;
        this.i = unlockHandler;
        this.j = copyHandler;
        this.k = webDavModifyingMethodHandler;
        this.l = webDavModifyingAndHeaderCheckingMethodHandler;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    private String[] a(HttpServletRequest httpServletRequest, String string) {
        string = WebDavUtil.a(string);
        return WebDavUtil.a(httpServletRequest, string);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public void doFilter(ServletRequest object, ServletResponse object2, FilterChain filterChain) {
        boolean bl;
        void var2_3;
        void var3_5;
        if (!(object instanceof HttpServletRequest) || !this.d.a()) {
            var3_5.doFilter(object, (ServletResponse)var2_3);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)object;
        HttpServletResponse httpServletResponse = (HttpServletResponse)var2_3;
        HttpServletRequest httpServletRequest2 = httpServletRequest;
        CharSequence[] charSequenceArray = this.a(httpServletRequest2, httpServletRequest2.getRequestURI());
        a.debug("WebDAV method {} for: {}", (Object)httpServletRequest.getMethod(), (Object)String.join((CharSequence)"/", charSequenceArray));
        if (charSequenceArray != null && charSequenceArray.length > 0 && charSequenceArray[0] != null && ((String)charSequenceArray[0]).equals("placeholder")) {
            var3_5.doFilter(object, (ServletResponse)var2_3);
            return;
        }
        String string = this.b.authenticateRequest(httpServletRequest);
        ConfluenceUser confluenceUser = this.e.getUserByName(string);
        if (string == null || confluenceUser == null) {
            a.debug("    Unauthenticated user - passing to default handler");
            if (!httpServletRequest.getMethod().equals("OPTIONS")) {
                var3_5.doFilter(object, (ServletResponse)var2_3);
                return;
            }
            B b2 = new B(httpServletResponse);
            var3_5.doFilter(object, (ServletResponse)b2);
            a.debug("Result for OPTIONS was {}", (Object)b2.b());
            if (b2.b() == 401) {
                httpServletResponse.setStatus(200);
                httpServletResponse.setHeader("Allow", "OPTIONS, GET, HEAD, POST, TRACE, PROPFIND, PROPPATCH, MKCOL, COPY, PUT, DELETE, MOVE, LOCK, UNLOCK");
                httpServletResponse.setHeader("DAV", "1, 2");
                httpServletResponse.setHeader("MS-Author-Via", "DAV");
                return;
            }
            WebDavUtil.a(b2, httpServletResponse);
            return;
        }
        this.b(httpServletRequest, string);
        ae ae2 = this.c.a(confluenceUser, (String[])charSequenceArray);
        String string2 = httpServletRequest.getHeader("Destination");
        CharSequence[] charSequenceArray2 = null;
        ae ae3 = null;
        if (string2 != null) {
            charSequenceArray2 = this.a(httpServletRequest, string2);
        }
        if (charSequenceArray2 != null) {
            a.debug("WebDAV destination: {}", (Object)String.join((CharSequence)"/", charSequenceArray2));
            ae3 = this.c.a(confluenceUser, (String[])charSequenceArray2);
        }
        boolean bl2 = ae2 != null && this.f.isLockpointEnabledInSpace(ae2.b);
        boolean bl3 = bl = ae3 != null && this.f.isLockpointEnabledInSpace(ae3.b);
        if (bl2 || bl) {
            Object object3 = this.a();
            String string3 = httpServletRequest.getMethod();
            if ((object3 = object3.get(string3)) != null && (ae2 != null || ((WebDavMethodHandler)object3).acceptsNonAttachmentArguments())) {
                String string4;
                WebDavHandlerParams webDavHandlerParams = new WebDavHandlerParams();
                new WebDavHandlerParams().a = charSequenceArray;
                webDavHandlerParams.b = httpServletRequest;
                webDavHandlerParams.c = httpServletResponse;
                webDavHandlerParams.d = var3_5;
                webDavHandlerParams.e = ae2;
                webDavHandlerParams.f = string;
                webDavHandlerParams.g = confluenceUser;
                webDavHandlerParams.h = string2;
                webDavHandlerParams.i = charSequenceArray2;
                webDavHandlerParams.j = ae3;
                if (((WebDavMethodHandler)object3).shouldAccessBeDeniedDueToLock(webDavHandlerParams)) {
                    return;
                }
                if (((WebDavMethodHandler)object3).mustDenyIfNoneMatch() && (string4 = httpServletRequest.getHeader("If-None-Match")) != null) {
                    a.debug("Returning 412 for PUT with If-None-Match");
                    webDavHandlerParams.c.setStatus(412);
                    return;
                }
                ((WebDavMethodHandler)object3).prepareFilter(webDavHandlerParams);
                if (this.a((WebDavMethodHandler)object3, webDavHandlerParams)) {
                    return;
                }
                ((WebDavMethodHandler)object3).doFilter(webDavHandlerParams);
                this.b((WebDavMethodHandler)object3, webDavHandlerParams);
                ((WebDavMethodHandler)object3).commitServletResult(webDavHandlerParams);
                this.a(httpServletRequest.getSession(), string);
                return;
            }
        }
        var3_5.doFilter(object, (ServletResponse)var2_3);
        this.a(httpServletRequest.getSession(), string);
    }

    private Map<String, WebDavMethodHandler> a() {
        HashMap<String, WebDavMethodHandler> hashMap = new HashMap<String, WebDavMethodHandler>();
        hashMap.put("LOCK", this.g);
        hashMap.put("MOVE", this.h);
        hashMap.put("UNLOCK", this.i);
        hashMap.put("COPY", this.j);
        hashMap.put("POST", this.k);
        hashMap.put("DELETE", this.k);
        hashMap.put("MKCOL", this.k);
        hashMap.put("PUT", this.l);
        hashMap.put("PROPPATCH", this.k);
        return hashMap;
    }

    private boolean a(WebDavMethodHandler object, WebDavHandlerParams webDavHandlerParams) {
        TransactionTemplate transactionTemplate = this.c.a();
        object = (a)transactionTemplate.execute((TransactionCallback)new ac((WebDavMethodHandler)object, webDavHandlerParams));
        try {
            if (((a)object).b != null) {
                throw ((a)object).b;
            }
        }
        catch (Exception exception) {
            a.error("Error propagating exception", (Throwable)exception);
        }
        return ((a)object).a;
    }

    private boolean b(WebDavMethodHandler object, WebDavHandlerParams webDavHandlerParams) {
        TransactionTemplate transactionTemplate = this.c.a();
        object = (a)transactionTemplate.execute((TransactionCallback)new ad((WebDavMethodHandler)object, webDavHandlerParams));
        try {
            if (((a)object).b != null) {
                throw ((a)object).b;
            }
        }
        catch (Exception exception) {
            a.error("Error propagating exception", (Throwable)exception);
        }
        return ((a)object).a;
    }

    private void b(HttpServletRequest httpServletRequest, String string) {
        WeakReference<Object> weakReference = (httpServletRequest = httpServletRequest.getSession()).getAttribute("com.atlassian.confluence.extra.webdav.ConfluenceDavSession");
        if (weakReference == null && this.m.containsKey(string)) {
            try {
                weakReference = this.m.get(string);
                weakReference = weakReference.get();
                if (weakReference == null) {
                    this.m.remove(string);
                    return;
                }
                httpServletRequest.setAttribute("com.atlassian.confluence.extra.webdav.ConfluenceDavSession", weakReference);
            }
            catch (Throwable throwable) {
                a.warn("WebDav session had expired, so removing", throwable);
                this.m.remove(string);
            }
        }
    }

    private void a(HttpSession object, String string) {
        if (object != null && (object = object.getAttribute("com.atlassian.confluence.extra.webdav.ConfluenceDavSession")) != null) {
            this.m.put(string, new WeakReference<HttpSession>((HttpSession)object));
        }
    }

    public static final class a {
        public boolean a;
        public Exception b;
    }
}

