/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.velocity;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.actions.AbstractPageAwareAction;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.webresource.ConfluenceWebResourceManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.cenotelabs.lockpoint.I;
import com.cenotelabs.lockpoint.L;
import com.cenotelabs.lockpoint.activeobjects.exceptions.LockpointAttachmentNotFoundException;
import com.cenotelabs.lockpoint.activeobjects.services.LockService;
import com.cenotelabs.lockpoint.framework.LockpointServletActionContext;
import com.cenotelabs.lockpoint.licensing.SimpleLicenseManager;
import com.cenotelabs.lockpoint.locks.AttachmentHtmlLockStatusGenerator;
import com.cenotelabs.lockpoint.locks.LockHelper;
import com.cenotelabs.lockpoint.r;
import com.cenotelabs.lockpoint.services.LockpointContentService;
import com.cenotelabs.lockpoint.services.LockpointSpaceService;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import com.cenotelabs.lockpoint.util.DateHelper;
import com.cenotelabs.lockpoint.util.LockpointUtil;
import com.cenotelabs.lockpoint.util.LockpointXsrfTokenGenerator;
import com.cenotelabs.lockpoint.util.NullAcceptingDateFormat;
import com.cenotelabs.lockpoint.xrefs.PluginLinksManager;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VelocityHelper {
    private static final Logger a = LoggerFactory.getLogger(VelocityHelper.class);
    private final LockpointContentService b;
    private final SimpleLicenseManager c;
    private final LockpointSpaceService d;
    private final LockpointUtil e;
    private final SpaceAttributesManager f;
    private final PluginLinksManager g;
    private final ThemeManager h;
    private final DateHelper i;
    private final AttachmentHtmlLockStatusGenerator j;
    private final LockpointXsrfTokenGenerator k;
    private final ConfluenceWebResourceManager l;
    private final LockpointServletActionContext m;
    private final LockService n;
    private final LockHelper o;

    @Inject
    public VelocityHelper(SimpleLicenseManager simpleLicenseManager, LockpointContentService lockpointContentService, DateHelper dateHelper, LockpointUtil lockpointUtil, LockpointSpaceService lockpointSpaceService, SpaceAttributesManager spaceAttributesManager, PluginLinksManager pluginLinksManager, @ComponentImport ThemeManager themeManager, LockpointXsrfTokenGenerator lockpointXsrfTokenGenerator, @ComponentImport ConfluenceWebResourceManager confluenceWebResourceManager, AttachmentHtmlLockStatusGenerator attachmentHtmlLockStatusGenerator, LockpointServletActionContext lockpointServletActionContext, LockService lockService, LockHelper lockHelper) {
        this.c = simpleLicenseManager;
        this.b = lockpointContentService;
        this.i = dateHelper;
        this.e = lockpointUtil;
        this.d = lockpointSpaceService;
        this.f = spaceAttributesManager;
        this.g = pluginLinksManager;
        this.h = themeManager;
        this.k = lockpointXsrfTokenGenerator;
        this.l = confluenceWebResourceManager;
        this.j = attachmentHtmlLockStatusGenerator;
        this.m = lockpointServletActionContext;
        this.n = lockService;
        this.o = lockHelper;
    }

    private static String a(String object) {
        Object object2;
        if (object == null) {
            return object;
        }
        object = new StringTokenizer((String)object, "&");
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (((StringTokenizer)object).hasMoreTokens()) {
            object2 = ((StringTokenizer)object).nextToken();
            if (((String)object2).equals("&") || ((String)object2).startsWith("onSuccess=")) continue;
            linkedList.add(object2);
        }
        object2 = linkedList.listIterator();
        object = "";
        while (object2.hasNext()) {
            if (!((String)object).equals("")) {
                object = (String)object + "&";
            }
            object = (String)object + String.valueOf(object2.next());
        }
        if (((String)object).equals("")) {
            return null;
        }
        return object;
    }

    private static String b(String object) {
        try {
            object = "&onSuccess=" + URLEncoder.encode((String)object, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = "";
        }
        return object;
    }

    public String getContextPath() {
        HttpServletRequest httpServletRequest = this.m.getRequest();
        if (httpServletRequest == null) {
            return "";
        }
        return httpServletRequest.getContextPath();
    }

    public String getOnSuccess(Long object) {
        if (object == null) {
            return "";
        }
        HttpServletRequest httpServletRequest = this.m.getRequest();
        if (httpServletRequest == null) {
            return "";
        }
        if ((object = this.b.getAbstractPageById((Long)object)) == null) {
            return "";
        }
        String string = this.m.getContextName();
        if (string != null) {
            if (string.equals("unlock") || string.equals("lock") || string.equals("notifyme") || string.equals("cancelnotify")) {
                return "";
            }
            if (string.equals("rendermacro")) {
                a.debug("Returning special URL path for rendermacro: {}", (Object)object.getUrlPath());
                return VelocityHelper.b(object.getUrlPath());
            }
        }
        object = httpServletRequest.getContextPath();
        string = httpServletRequest.getRequestURI();
        String string2 = httpServletRequest.getQueryString();
        string2 = VelocityHelper.a(string2);
        if (!string.substring(0, ((String)object).length()).equals(object)) {
            return "";
        }
        object = httpServletRequest.getRequestURI().substring(((String)object).length());
        if (string2 != null) {
            object = (String)object + "?" + string2;
        }
        return VelocityHelper.b((String)object);
    }

    public String lockedUserDisplayName(Attachment object) {
        try (I i2 = L.a("VelocityHelper#lockedUserDisplayName");){
            object = this.n.getLock((Attachment)object);
            ConfluenceUser confluenceUser = this.o.getLockOwnerUser((r)object);
            object = confluenceUser != null ? confluenceUser.getFullName() : null;
            return object;
        }
    }

    public String getLockDate(AbstractPage object, String object2) {
        if (object == null) {
            a.error("Page cannot be null");
            return "";
        }
        try {
            object = this.n.getLock((ContentEntityObject)object, (String)object2);
            object2 = this.i.getDateTimeFormatForUser(AuthenticatedUserThreadLocal.get());
            object = ((NullAcceptingDateFormat)object2).format(this.o.getLockDate((r)object));
            if (object != null) {
                return object;
            }
            return "";
        }
        catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
            return "";
        }
    }

    public boolean isLocked(AbstractPage object, String string) {
        try (I i2 = L.a("VelocityHelper#isLocked.a");){
            I i3;
            if (object == null) {
                a.error("Page cannot be null");
                return false;
            }
            try {
                i3 = L.a("VelocityHelper#isLocked.a.1");
                try {
                    object = this.n.getLock((ContentEntityObject)object, string);
                }
                finally {
                    if (i3 != null) {
                        i3.close();
                    }
                }
            }
            catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
                if (i2 != null) {
                    i2.close();
                }
                return false;
            }
            i3 = L.a("VelocityHelper#isLocked.a.2");
            try {
                boolean bl = this.o.isLockedByAnyone((r)object);
                if (i3 != null) {
                    i3.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (i3 != null) {
                    try {
                        i3.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    public boolean isLocked(Attachment object) {
        I i2 = L.a("VelocityHelper#isLocked.b");
        try {
            object = this.n.getLock((Attachment)object);
            boolean bl = this.o.isLockedByAnyone((r)object);
            if (i2 != null) {
                i2.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (i2 != null) {
                    try {
                        i2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isLockedByCurrentUser(AbstractPage object, String string) {
        try (I i2 = L.a("VelocityHelper#isLockedByCurrentUser.a");){
            if (object == null) {
                a.error("Page cannot be null");
                return false;
            }
            object = this.n.getLock((ContentEntityObject)object, string);
            boolean bl = this.o.isLockedByGivenUser((r)object, AuthenticatedUserThreadLocal.get());
            return bl;
        }
        catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
            return false;
        }
    }

    public boolean isLockedByCurrentUser(Attachment object) {
        I i2 = L.a("VelocityHelper#isLockedByCurrentUser.b");
        try {
            object = this.n.getLock((Attachment)object);
            boolean bl = this.o.isLockedByGivenUser((r)object, AuthenticatedUserThreadLocal.get());
            if (i2 != null) {
                i2.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (i2 != null) {
                    try {
                        i2.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
                return false;
            }
        }
    }

    public String addSafeEditPrefix(String string, AbstractPage object, String string2) {
        URI uRI;
        if (object == null) {
            a.error("Page cannot be null");
            return string;
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            a.error("Could not process URL '{}' for safe edit: {}", (Object)string, (Object)uRISyntaxException);
            return string;
        }
        Object object2 = uRI.getPath();
        Object object3 = this.m.getRequest();
        if (object3 == null) {
            a.debug("Unable to get request from LockpointServletActionContext in order to fix URL {}", (Object)string);
            return string;
        }
        if ((object3 = object3.getContextPath()) != null && ((String)object2).startsWith((String)object3)) {
            object2 = ((String)object2).substring(((String)object3).length());
        } else {
            object3 = null;
        }
        object2 = "/plugins/servlet/lockpoint/safeedit/" + object.getId() + "/" + string2 + (String)object2;
        if (object3 != null) {
            object2 = (String)object3 + (String)object2;
        }
        try {
            object = new URI(uRI.getScheme(), uRI.getUserInfo(), uRI.getHost(), uRI.getPort(), (String)object2, uRI.getQuery(), uRI.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            a.warn("Unable to parse newly-generated URL: {}", object2);
            return string;
        }
        string = ((URI)object).toASCIIString();
        return string;
    }

    public String getFancyDateFromLong(long l2) {
        NullAcceptingDateFormat nullAcceptingDateFormat = this.i.getDateTimeFormatForUser(AuthenticatedUserThreadLocal.get());
        return nullAcceptingDateFormat.format(new Date(l2));
    }

    public Boolean isPowerPoint(AbstractPage object, String stringArray) {
        if (object == null) {
            a.error("Page cannot be null");
            return Boolean.FALSE;
        }
        String[] stringArray2 = new String[]{"ppt", "pot", "pptx", "ppsx", "potx", "pptm"};
        try {
            object = this.n.getLock((ContentEntityObject)object, (String)stringArray);
            object = object.a();
            object = object.getFileExtension().toLowerCase(Locale.getDefault());
            stringArray = stringArray2;
            int cfr_ignored_0 = stringArray2.length;
            for (int i2 = 0; i2 < 6; ++i2) {
                String string = stringArray[i2];
                if (!string.equals(object)) continue;
                return Boolean.TRUE;
            }
        }
        catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public static String fixUnencodedFilenameInURL(String string, String object, String object2) {
        String string2;
        try {
            string2 = URLEncoder.encode((String)object2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
        if (string2.equals(object2)) {
            return string;
        }
        int n2 = string.indexOf((String)(object2 = (String)object + "=" + (String)object2));
        if (n2 == -1) {
            return string;
        }
        object2 = string.substring(n2 + ((String)object2).length());
        object = string.substring(0, n2) + (String)object + "=" + string2 + (String)object2;
        a.debug("Converted URL from {} to {}", (Object)string, object);
        return object;
    }

    public Boolean getShowAttachmentOwners() {
        return this.j.getShowAttachmentOwners();
    }

    public WebInterfaceContext injectWebInterfaceContextForAttachmentsMacro(WebInterfaceContext webInterfaceContext) {
        webInterfaceContext = DefaultWebInterfaceContext.copyOf((WebInterfaceContext)webInterfaceContext);
        webInterfaceContext.setParameter("fromAttachmentsMacro", (Object)"true");
        return webInterfaceContext;
    }

    public String getAdminPanelContext(Space object) {
        boolean bl = (object = object != null ? object.getKey() : null) != null && this.h.getSpaceTheme((String)object).hasSpaceSideBar();
        if (bl) {
            return "spacecontentpanel";
        }
        return "spaceadminpanel";
    }

    public Boolean enabledInSpace(Space object) {
        try (I i2 = L.a("VelocityHelper#enabledInSpace-a");){
            object = object != null && this.f.isLockpointEnabledInSpace((Space)object);
            return object;
        }
    }

    public Boolean enabledInSpace(ContentEntityObject object) {
        try (I i2 = L.a("VelocityHelper#enabledInSpace-b");){
            object = this.f.isLockpointEnabledInSpace((ContentEntityObject)object);
            return object;
        }
    }

    public Boolean enabledInSpace(String object) {
        try (I i2 = L.a("VelocityHelper#enabledInSpace-c");){
            VelocityHelper velocityHelper = this;
            object = velocityHelper.enabledInSpace(velocityHelper.d.getSpaceByKey((String)object));
            return object;
        }
    }

    private String a(AbstractPageAwareAction object, String string, AbstractPage abstractPage, List<Attachment> object2) {
        I i2;
        block12: {
            HttpServletRequest httpServletRequest;
            block11: {
                i2 = L.a("VelocityHelper#getLockOrUnlockAllLink");
                try {
                    httpServletRequest = this.m.getRequest();
                    if (httpServletRequest != null) break block11;
                    String string2 = "#";
                    if (i2 != null) {
                        i2.close();
                    }
                    return string2;
                }
                catch (Throwable throwable) {
                    if (i2 != null) {
                        try {
                            i2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            if (object2.size() <= 0) break block12;
            try {
                Object object3 = this.k.getToken(httpServletRequest, false);
                object3 = object3 != null ? "&atl_token=" + (String)object3 : "";
                object2 = object2.stream().map(EntityObject::getId).map(l2 -> Long.toString(l2)).collect(Collectors.joining(","));
                object = httpServletRequest.getContextPath() + "/lockpoint/" + string + "?pageId=" + abstractPage.getId() + "&onSuccess=" + URLEncoder.encode("/pages/viewpage.action?pageId=" + object.getPageId(), "UTF-8") + "&a=" + (String)object2 + (String)object3;
                if (i2 != null) {
                    i2.close();
                }
                return object;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        String string3 = "#";
        if (i2 != null) {
            i2.close();
        }
        return string3;
    }

    public String getLockAllLink(AbstractPageAwareAction abstractPageAwareAction, AbstractPage abstractPage, List<Attachment> list) {
        return this.a(abstractPageAwareAction, "lockall.action", abstractPage, list);
    }

    public String getUnlockAllLink(AbstractPageAwareAction abstractPageAwareAction, AbstractPage abstractPage, List<Attachment> list) {
        return this.a(abstractPageAwareAction, "unlockall.action", abstractPage, list);
    }

    public Boolean hasPermissionToLockUnlockAll(ContentEntityObject object) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        try (I i2 = L.a("VelocityHelper#hasPermissionToLockUnlockAll");){
            object = this.e.hasPermissionToLockUnlockAll(confluenceUser, (ContentEntityObject)object);
            return object;
        }
    }

    public String getHiddenClasses() {
        Object object = this.g.getLinksToHide();
        StringBuilder stringBuilder = new StringBuilder();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append('.').append(string);
        }
        return stringBuilder.toString();
    }

    @HtmlSafe
    public String getAttachmentColumnHtml(Attachment object) {
        try {
            ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
            object = this.n.getLock((Attachment)object);
            return this.j.getAttachmentColumnHtmlFromAugmentedLock((r)object, confluenceUser);
        }
        catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
            return "";
        }
    }

    public boolean isActive() {
        return true;
    }

    @HtmlSafe
    public String getUserDisplayStringForAttachmentHtml(AbstractPage object, String string) {
        try {
            object = this.n.getLock((ContentEntityObject)object, string);
            return this.o.getUserDisplayStringForLock((r)object);
        }
        catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
            return "";
        }
    }

    @HtmlSafe
    public String requireGliffyResources() {
        Object object = "com.arsenale.plugins.lockpoint";
        ArrayList<String> arrayList = "lockpoint-gliffy-viewer-resources";
        object = (String)object + ":" + (String)((Object)arrayList);
        object = this.l.getResourceTags((String)object);
        arrayList = Pattern.compile("(<script.*?</script>)", 40);
        object = ((Pattern)((Object)arrayList)).matcher((CharSequence)object);
        arrayList = new ArrayList<String>();
        while (((Matcher)object).find()) {
            arrayList.add(((Matcher)object).group(1));
        }
        object = arrayList.stream().filter(string -> string.startsWith("<script src") || string.startsWith("<script type=\"text/javascript\" src") || string.startsWith("<script>")).collect(Collectors.joining("\n"));
        return object;
    }
}

