/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.modules.jobs;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.cenotelabs.lockpoint.lifecycle.PluginState;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PluginStateEnforcerJob
implements JobRunner {
    private static final Logger a = LoggerFactory.getLogger(PluginStateEnforcerJob.class);
    private PluginController b;
    private PluginAccessor c;
    private PluginState d;
    private boolean e;
    private boolean f;
    private long g;

    @Inject
    public PluginStateEnforcerJob(@ComponentImport PluginController pluginController, @ComponentImport PluginAccessor pluginAccessor, PluginState pluginState) {
        this.b = pluginController;
        this.c = pluginAccessor;
        this.d = pluginState;
        this.e = "false".equals(System.getProperty("com.cenotelabs.lockpoint.disablePluginStateEnforcement", "false"));
        this.f = false;
        this.g = 0L;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        try {
            if (!this.e || this.f || !this.d.a()) {
                return JobRunnerResponse.success();
            }
            if (this.g == 0L) {
                this.g = System.currentTimeMillis() + 50000L;
            }
            if (System.currentTimeMillis() > this.g) {
                this.f = true;
                this.a();
            }
            return JobRunnerResponse.success();
        }
        catch (Throwable throwable) {
            a.error("PluginStateEnforcer job failed", throwable);
            return JobRunnerResponse.failed((Throwable)throwable);
        }
    }

    private void a() {
        a.debug("Running Lockpoint plugin state enforcement");
        this.a("confluence.sections.attachments");
        this.b("confluence.sections.attachments:edit");
        this.b("confluence.sections.attachments:remove");
        this.b("confluence.sections.attachments:remove-version");
        this.b("com.atlassian.confluence.extra.officeconnector:editattachmentinworditempathauth");
        this.b("com.atlassian.confluence.extra.officeconnector:editattachmentinworditem");
    }

    private void a(String string) {
        Plugin plugin = this.c.getPlugin(string);
        if (plugin == null) {
            return;
        }
        if ((plugin = plugin.getPluginState()) == com.atlassian.plugin.PluginState.ENABLED || plugin == com.atlassian.plugin.PluginState.ENABLING) {
            return;
        }
        this.b.enablePlugins(new String[]{string});
        a.warn("Lockpoint found the following plugin disabled, and enabled it: {}. {}", (Object)string, (Object)"To suppress this enablement, set JVM startup parameter -Dcom.cenotelabs.lockpoint.disablePluginStateEnforcement=true");
    }

    private void b(String string) {
        ModuleDescriptor moduleDescriptor = this.c.getPluginModule(string);
        if (moduleDescriptor == null || moduleDescriptor.isEnabled()) {
            return;
        }
        this.b.enablePluginModule(string);
        a.warn("Lockpoint found the following plugin module disabled, and enabled it: {}. {}", (Object)string, (Object)"To suppress this enablement, set JVM startup parameter -Dcom.cenotelabs.lockpoint.disablePluginStateEnforcement=true");
    }
}

