/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.modules.jobs;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.user.User;
import com.cenotelabs.lockpoint.I;
import com.cenotelabs.lockpoint.L;
import com.cenotelabs.lockpoint.activeobjects.models.LockModel;
import com.cenotelabs.lockpoint.activeobjects.models.Template;
import com.cenotelabs.lockpoint.activeobjects.services.LockService;
import com.cenotelabs.lockpoint.licensing.LicenseManagerReason;
import com.cenotelabs.lockpoint.licensing.SimpleLicenseManager;
import com.cenotelabs.lockpoint.lifecycle.PluginState;
import com.cenotelabs.lockpoint.lifecycle.StartupAndShutdown;
import com.cenotelabs.lockpoint.locks.LockHelper;
import com.cenotelabs.lockpoint.locks.LockManager;
import com.cenotelabs.lockpoint.mail.MailHelper;
import com.cenotelabs.lockpoint.mail.MailQueueItemFromContent;
import com.cenotelabs.lockpoint.model.EmailTemplate;
import com.cenotelabs.lockpoint.p;
import com.cenotelabs.lockpoint.r;
import com.cenotelabs.lockpoint.rest.transport.SpaceTimeoutsTransport;
import com.cenotelabs.lockpoint.services.LockpointDisabledUserService;
import com.cenotelabs.lockpoint.services.LockpointSpaceService;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import com.cenotelabs.lockpoint.util.DateHelper;
import com.cenotelabs.lockpoint.util.NullAcceptingDateFormat;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AutomaticUnlockJob
implements JobRunner {
    private static final Logger a = LoggerFactory.getLogger(AutomaticUnlockJob.class);
    private final PluginState b;
    private final StartupAndShutdown c;
    private final TransactionTemplate d;
    private final LockpointSpaceService e;
    private final SpaceAttributesManager f;
    private final SimpleLicenseManager g;
    private final DateHelper h;
    private final UserAccessor i;
    private final MailHelper j;
    private final LockManager k;
    private final LockService l;
    private final LockHelper m;
    private final LockpointDisabledUserService n;

    @Inject
    public AutomaticUnlockJob(StartupAndShutdown startupAndShutdown, PluginState pluginState, @ComponentImport TransactionTemplate transactionTemplate, LockpointSpaceService lockpointSpaceService, SpaceAttributesManager spaceAttributesManager, SimpleLicenseManager simpleLicenseManager, DateHelper dateHelper, UserAccessor userAccessor, MailHelper mailHelper, LockManager lockManager, LockService lockService, LockHelper lockHelper, LockpointDisabledUserService lockpointDisabledUserService) {
        this.c = startupAndShutdown;
        this.b = pluginState;
        this.d = transactionTemplate;
        this.e = lockpointSpaceService;
        this.f = spaceAttributesManager;
        this.g = simpleLicenseManager;
        this.h = dateHelper;
        this.i = userAccessor;
        this.j = mailHelper;
        this.k = lockManager;
        this.l = lockService;
        this.m = lockHelper;
        this.n = lockpointDisabledUserService;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest object) {
        a.debug("Cron job running");
        try {
            object = L.b("Lockpoint AutomaticUnlockJob");
            try {
                this.a();
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        catch (Throwable throwable) {
            a.error("Lockpoint automatic unlock job failed to complete", throwable);
        }
        a.debug("Cron job finished");
        return JobRunnerResponse.success();
    }

    private void a() {
        I i2;
        if (!this.b.a()) {
            a.debug("We are not yet enabled, so skipping this cron execution.");
            return;
        }
        try (Iterator iterator = L.a("AutomaticUnlockJob:testLicense");){
            if (!this.b()) {
                return;
            }
        }
        try {
            i2 = L.a("AutomaticUnlockJob:getAllLocks");
            try {
                iterator = (List)this.d.execute(this.l::getAllLocks);
            }
            finally {
                if (i2 != null) {
                    i2.close();
                }
            }
        }
        catch (Throwable throwable) {
            a.error("Error fetching list of locks inside transaction", throwable);
            return;
        }
        i2 = null;
        I i3 = L.a("AutomaticUnlockJob:iterateLocks");
        try {
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                r r2 = (r)iterator.next();
                long l2 = r2.a().getSpace().getId();
                try (I i4 = L.a("AutomaticUnlockJob:getSpaces");){
                    if (i2 == null || i2.getId() != l2) {
                        i2 = this.e.getSpaceById(r2.e().getId());
                    }
                }
                i4 = i2;
                try {
                    I i5 = L.a("AutomaticUnlockJob:testEnabledInTransaction");
                    try {
                        this.d.execute(() -> this.b((Space)i4, r2));
                    }
                    finally {
                        if (i5 == null) continue;
                        i5.close();
                    }
                }
                catch (Throwable throwable) {
                    a.error("Could not evaluate attachment for unlock: " + String.valueOf(r2), throwable);
                }
            }
            if (i3 != null) {
                i3.close();
                return;
            }
        }
        catch (Throwable throwable) {
            if (i3 != null) {
                try {
                    i3.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
    }

    private void a(Space space, r r2) {
        Object object;
        long l2;
        Object object2;
        a.debug("Begin evaluating attachment {} for potential unlock requirements", (Object)r2);
        long l3 = System.currentTimeMillis();
        try (I i2 = L.a("AutomaticUnlockJob:getTimeoutsForSpace");){
            object2 = this.f.getTimeoutsForSpace(space);
        }
        long l4 = 3600000L * ((SpaceTimeoutsTransport)object2).getWarningTimeout();
        long l5 = 3600000L * ((SpaceTimeoutsTransport)object2).getUnlockTimeout();
        object2 = this.m.getLockDate(r2);
        if (object2 == null) {
            a.warn("Found invalid lock date for attachment {}", (Object)r2);
            return;
        }
        long l6 = ((Date)object2).getTime();
        object2 = r2.a();
        boolean bl = false;
        ContentEntityObject contentEntityObject = object2.getContainer();
        if (contentEntityObject != null && contentEntityObject.isDeleted()) {
            bl = true;
        }
        long l7 = l4;
        long l8 = l5;
        Date date = new Date(l6 + l8);
        ConfluenceUser confluenceUser = this.m.getLockOwnerUser(r2);
        NullAcceptingDateFormat nullAcceptingDateFormat = this.h.getDateTimeFormatForUser(confluenceUser);
        long l9 = r2.a().getSpace().getId();
        if (l9 != (l2 = r2.b().getSpaceId())) {
            object = contentEntityObject != null ? Long.valueOf(contentEntityObject.getId()) : null;
            a.debug("Housekeeping: attachmentId {} was recorded as being in space {}, but it actually belongs to space {}, so we are rewriting its metadata. This is normal if its parent, page {}, was moved to a new space.", new Object[]{object2.getId(), l2, l9, object});
            object2 = r2.b();
            ((LockModel)object2).setSpaceId(l9);
            this.l.saveModel((LockModel)object2);
        }
        if (l8 != 0L && l3 > l6 + l8) {
            a.debug("Forcing the unlock of attachment {}", (Object)r2);
            if (bl) {
                a.debug("Attachment belongs to a deleted page, so unlock email will not be sent for: {}", (Object)r2);
            } else {
                object = L.a("AutomaticUnlockJob:sendEmail:unlock");
                try {
                    object2 = this.f.getTemplateForSpace(space, Template.Type.UNLOCK, confluenceUser);
                    this.a(r2, date, ((EmailTemplate)object2).getSubject(), ((EmailTemplate)object2).getBody(), nullAcceptingDateFormat);
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
            }
            a.debug("Unlocking within transaction");
            object = L.a("AutomaticUnlockJob:doUnlock");
            try {
                this.k.unlockSystem(r2);
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        if (l7 != 0L && l3 > l6 + l7 && !r2.b().isSentWarningEmail()) {
            if (bl) {
                a.debug("Attachment belongs to a deleted page, so warning email will not be sent for: {}", (Object)r2);
            } else {
                object = L.a("AutomaticUnlockJob:sendEmail:warning");
                try {
                    a.debug("Sending an unlock warning for attachment {}", (Object)r2);
                    try (I i3 = L.a("AutomaticUnlockJob:sendEmail:warning:getTemplate");){
                        object2 = this.f.getTemplateForSpace(space, Template.Type.WARNING, confluenceUser);
                    }
                    this.a(r2, date, ((EmailTemplate)object2).getSubject(), ((EmailTemplate)object2).getBody(), nullAcceptingDateFormat);
                }
                finally {
                    if (object != null) {
                        object.close();
                    }
                }
            }
            object = L.a("AutomaticUnlockJob:updateWarning");
            try {
                a.debug("Marking as having warning email sent in database");
                this.l.setSentWarningMail(r2, true);
            }
            finally {
                if (object != null) {
                    object.close();
                }
            }
        }
        a.debug("Finished evaluating attachment {} for potential unlock requirements", (Object)r2);
    }

    /*
     * Loose catch block
     */
    private void a(r object, Date date, String object2, String string, NullAcceptingDateFormat nullAcceptingDateFormat) {
        ConfluenceUser confluenceUser;
        Object object3;
        I i2;
        block34: {
            block36: {
                block33: {
                    block32: {
                        i2 = L.a("AutomaticUnlockJob:sendTemplatedEmail");
                        try {
                            object3 = L.a("AutomaticUnlockJob:sendTemplatedEmail:getLockOwnerUser");
                            try {
                                confluenceUser = this.m.getLockOwnerUser((r)object);
                            }
                            finally {
                                if (object3 != null) {
                                    object3.close();
                                }
                            }
                            if (confluenceUser != null) break block32;
                            a.warn("Could not find owner '{}' of locked attachment {}", (Object)this.m.getLockOwnerDisplayName((r)object), (Object)((r)object).a());
                            if (i2 != null) {
                                i2.close();
                            }
                            return;
                        }
                        catch (Throwable throwable) {
                            if (i2 != null) {
                                try {
                                    i2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                    }
                    object3 = L.a("AutomaticUnlockJob:sendTemplatedEmail:isDeactivated");
                    if (!this.n.isDisabled((User)confluenceUser)) break block33;
                    a.warn("User {} of locked attachment {} is deactivated; no email sent", (Object)confluenceUser.getName(), (Object)((r)object).a());
                    if (object3 != null) {
                        object3.close();
                    }
                    if (i2 != null) {
                        i2.close();
                    }
                    return;
                }
                if (object3 != null) {
                    object3.close();
                }
                break block36;
                {
                    catch (Throwable throwable) {
                        if (object3 != null) {
                            try {
                                object3.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                }
            }
            object3 = confluenceUser.getEmail();
            if (object3 != null && ((String)object3).length() != 0) break block34;
            a.warn("Could not send Cenote Lockpoint notification to user {} because the user's email address was empty.", (Object)confluenceUser.getFullName());
            if (i2 != null) {
                i2.close();
            }
            return;
        }
        object2 = new MailQueueItemFromContent((User)confluenceUser, string, (String)object2);
        string = ((r)object).a();
        object3 = ((r)object).b().getLockedDate();
        this.j.addAttachmentBaseVelocityContext((MailQueueItemFromContent)((Object)object2), (Attachment)string, (Long)object3, nullAcceptingDateFormat, this.m.getLockOwnerDisplayName((r)object));
        ((MailQueueItemFromContent)((Object)object2)).addVelocityContextParam("expirationDate", nullAcceptingDateFormat.format(date));
        a.debug("Queueing email for {} for attachment {}", (Object)confluenceUser.getFullName(), (Object)((r)object).a());
        object = L.a("AutomaticUnlockJob:sendTemplatedEmail:queueEmail");
        try {
            this.j.sendEmail((MailQueueItemFromContent)((Object)object2));
        }
        finally {
            if (object != null) {
                object.close();
            }
        }
        if (i2 != null) {
            i2.close();
            return;
        }
    }

    private boolean b() {
        p p2 = this.g.getLicenseStatus(Locale.getDefault(), true);
        if (p2.a() != LicenseManagerReason.a) {
            a.warn("Plugin not yet activated: cron job standing down!");
            if (this.b.a()) {
                try {
                    this.c.b();
                }
                catch (Exception exception) {
                    a.error("Error disabling plugin", (Throwable)exception);
                }
            }
            return false;
        }
        this.g.checkForLicenseExpiration(Boolean.TRUE);
        return true;
    }

    private /* synthetic */ Integer b(Space space, r r2) {
        if (!this.f.isLockpointEnabledInSpace(space)) {
            return 0;
        }
        try (I i2 = L.a("AutomaticUnlockJob:evaluateOneLockWithinTransaction");){
            this.a(space, r2);
        }
        return 0;
    }
}

