/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.migration;

import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.ContainerType;
import com.atlassian.migration.app.ContainerV1;
import com.atlassian.migration.app.SiteContainerV1;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableListener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.cenotelabs.lockpoint.migration.AttachmentDataCollector;
import com.cenotelabs.lockpoint.migration.GlobalDataCollector;
import com.cenotelabs.lockpoint.migration.SpaceDataCollector;
import com.cenotelabs.lockpoint.t;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService
@Named
public class LockpointCloudMigrationListener
implements DiscoverableListener {
    private static final Logger log = LoggerFactory.getLogger(LockpointCloudMigrationListener.class);
    private static final String APP_KEY = "com.arsenale.plugins.lockpoint.local";
    private final SpaceDataCollector spaceDataCollector;
    private final AttachmentDataCollector attachmentDataCollector;
    private final GlobalDataCollector globalDataCollector;

    @Inject
    public LockpointCloudMigrationListener(SpaceDataCollector spaceDataCollector, AttachmentDataCollector attachmentDataCollector, GlobalDataCollector globalDataCollector) {
        this.spaceDataCollector = spaceDataCollector;
        this.attachmentDataCollector = attachmentDataCollector;
        this.globalDataCollector = globalDataCollector;
    }

    public String getCloudAppKey() {
        return APP_KEY;
    }

    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_UGC, AccessScope.MIGRATION_TRACING_IDENTITY, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }

    public void onStartAppMigration(AppCloudMigrationGateway appCloudMigrationGateway, String string, MigrationDetailsV1 object) {
        Object object2;
        log.info("onStartAppMigration: transferId={}, migrationId={}, name={}, confluenceClientKey={}, cloudUrl={}", new Object[]{string, object.getMigrationId(), object.getName(), object.getConfluenceClientKey(), object.getCloudUrl()});
        super.onStartAppMigration(appCloudMigrationGateway, string, object);
        this.logSites(appCloudMigrationGateway, string);
        object = new t(appCloudMigrationGateway, string, (MigrationDetailsV1)object, this.spaceDataCollector, this.attachmentDataCollector, this.globalDataCollector);
        object = object.a();
        log.info("Final serialized migration: {}", (Object)object.toString());
        log.info("Uploading data to cloud");
        try {
            object2 = appCloudMigrationGateway.createAppData(string, "lockpoint-migration");
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)object2, StandardCharsets.UTF_8);
                object.writeTo((Writer)outputStreamWriter);
                outputStreamWriter.flush();
            }
            finally {
                if (object2 != null) {
                    ((OutputStream)object2).close();
                }
            }
        }
        catch (IOException iOException) {
            log.error("Could not upload data to cloud", (Throwable)iOException);
        }
        log.info("Upload to cloud complete");
        object2 = appCloudMigrationGateway.getCloudFeedbackIfPresent(string);
        if (((Optional)object2).isPresent()) {
            log.info("onStartAppMigration: cloudFeedbackResponse={}", ((Optional)object2).get());
        }
    }

    private void logSites(AppCloudMigrationGateway appCloudMigrationGateway, String iterator) {
        appCloudMigrationGateway = appCloudMigrationGateway.getPaginatedContainers((String)((Object)iterator), ContainerType.Site, 1);
        while (appCloudMigrationGateway.next()) {
            iterator = appCloudMigrationGateway.getContainers();
            log.info("Site containers = {}", (Object)iterator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ContainerV1 containerV1 = (ContainerV1)iterator.next();
                containerV1 = (SiteContainerV1)containerV1;
                log.info(" One site container: {}", (Object)containerV1);
                log.info("   Selections: {}", (Object)containerV1.getSelections());
            }
        }
    }
}

