/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.migration;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.cenotelabs.lockpoint.activeobjects.models.LockModel;
import com.cenotelabs.lockpoint.activeobjects.services.LockService;
import com.cenotelabs.lockpoint.r;
import com.cenotelabs.lockpoint.services.LockpointSpaceService;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import com.cenotelabs.lockpoint.t;
import com.cenotelabs.lockpoint.v;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AttachmentDataCollector {
    private static final Logger a = LoggerFactory.getLogger(AttachmentDataCollector.class);
    private final TransactionTemplate b;
    private final LockService c;
    private final LockpointSpaceService d;
    private final SpaceAttributesManager e;

    @Inject
    public AttachmentDataCollector(@ComponentImport TransactionTemplate transactionTemplate, LockService lockService, LockpointSpaceService lockpointSpaceService, SpaceAttributesManager spaceAttributesManager) {
        this.b = transactionTemplate;
        this.c = lockService;
        this.d = lockpointSpaceService;
        this.e = spaceAttributesManager;
    }

    public JsonObject migrateLocks(t t2, Set<String> set) {
        JsonObject jsonObject = new JsonObject();
        Object object = (List)this.b.execute(this.c::getAllLocks);
        Space space = null;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (r)object.next();
            long l2 = ((r)object2).a().getSpace().getId();
            if (!set.contains(Long.toString(l2))) continue;
            if (space == null || space.getId() != l2) {
                space = (Space)this.b.execute(() -> this.a((r)object2));
                a.debug("Now iterating over locks in space {}", (Object)space.getKey());
            }
            Space space2 = space;
            if ((space2 = (JsonObject)this.b.execute(() -> this.a(space2, t2, (r)object2))) == null) continue;
            long l3 = ((r)object2).c();
            if ((object2 = t2.a(l3)) != null) {
                jsonObject.add((String)object2, (JsonValue)space2);
                continue;
            }
            a.error("Could not map attachment ID {} to cloud", (Object)l3);
        }
        return jsonObject;
    }

    private JsonObject a(t t2, r r2) {
        a.info("Migrating data for attachmentId {}", (Object)r2.c());
        JsonObject jsonObject = new JsonObject();
        LockModel lockModel = r2.b();
        String string = lockModel.getNotifications();
        String string2 = t2.a(lockModel.getOwner());
        if (string2 == null) {
            a.error("Skipping lock migration: could not map owner for attachmentId {} of {}", (Object)r2.c(), (Object)lockModel.getOwner());
            return null;
        }
        jsonObject.add("owner", string2);
        jsonObject.add("lockDate", lockModel.getLockedDate());
        jsonObject.add("notifications", (JsonValue)(string != null ? AttachmentDataCollector.a(t2, string) : Json.array()));
        jsonObject.add("warningSent", lockModel.isSentWarningEmail());
        return jsonObject;
    }

    private static JsonArray a(t t2, String object) {
        object = Arrays.asList(((String)object).split(LockService.a));
        return v.a(t2.a((List<String>)object));
    }

    private /* synthetic */ JsonObject a(Space space, t t2, r r2) {
        if (!this.e.isLockpointEnabledInSpace(space)) {
            return null;
        }
        return this.a(t2, r2);
    }

    private /* synthetic */ Space a(r r2) {
        return this.d.getSpaceById(r2.e().getId());
    }
}

