/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.framework;

import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import com.atlassian.sal.api.message.I18nResolver;
import com.cenotelabs.lockpoint.framework.LockpointServletActionContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class DeferredMessageManager {
    private final LockpointServletActionContext lockpointServletActionContext;
    private final I18nResolver i18nResolver;
    private String SESSION_KEY_LOCKPOINT_ERRORS = "lockpoint.errors";
    private String SESSION_KEY_LOCKPOINT_NOTE = "lockpoint.warnings";

    public DeferredMessageManager(LockpointServletActionContext lockpointServletActionContext, I18nResolver i18nResolver) {
        this.lockpointServletActionContext = lockpointServletActionContext;
        this.i18nResolver = i18nResolver;
    }

    private HttpSession getSession() {
        HttpServletRequest httpServletRequest = this.lockpointServletActionContext.getRequest();
        if (httpServletRequest != null) {
            return httpServletRequest.getSession();
        }
        return null;
    }

    private List<String> getAndClearDeferredMessages(String string) {
        HttpSession httpSession = this.getSession();
        List<String> list = new ArrayList<String>();
        if (httpSession != null) {
            Object object = httpSession.getAttribute(string);
            if (object instanceof List) {
                list = (List)object;
            }
            httpSession.setAttribute(string, new ArrayList());
        }
        return list;
    }

    public List<String> getAndClearDeferredErrors() {
        DeferredMessageManager deferredMessageManager = this;
        return deferredMessageManager.getAndClearDeferredMessages(deferredMessageManager.SESSION_KEY_LOCKPOINT_ERRORS);
    }

    public List<String> getAndClearDeferredNotes() {
        DeferredMessageManager deferredMessageManager = this;
        return deferredMessageManager.getAndClearDeferredMessages(deferredMessageManager.SESSION_KEY_LOCKPOINT_NOTE);
    }

    private void addDeferredMessage(String object, String string) {
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            ArrayList arrayList = httpSession.getAttribute((String)object);
            if (arrayList == null || !(arrayList instanceof List)) {
                arrayList = new ArrayList();
                httpSession.setAttribute((String)object, arrayList);
            }
            object = arrayList;
            object.add(string);
        }
    }

    public void addDeferredError(String string, Object ... objectArray) {
        DeferredMessageManager deferredMessageManager = this;
        deferredMessageManager.addDeferredMessage(deferredMessageManager.SESSION_KEY_LOCKPOINT_ERRORS, this.i18nResolver.getText(string, (Serializable[])PlainTextToHtmlConverter.encodeHtmlEntities((Object[])objectArray)));
    }

    public void addDeferredNote(String string, Object ... objectArray) {
        DeferredMessageManager deferredMessageManager = this;
        deferredMessageManager.addDeferredMessage(deferredMessageManager.SESSION_KEY_LOCKPOINT_NOTE, this.i18nResolver.getText(string, (Serializable[])PlainTextToHtmlConverter.encodeHtmlEntities((Object[])objectArray)));
    }
}

