/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.actions;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.actions.RemoveAttachedFileAction;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.atlassian.struts.xsrf.XsrfProtectionRequired;
import com.cenotelabs.lockpoint.activeobjects.exceptions.LockpointAttachmentNotFoundException;
import com.cenotelabs.lockpoint.activeobjects.services.LockService;
import com.cenotelabs.lockpoint.framework.LockpointServletActionContext;
import com.cenotelabs.lockpoint.lifecycle.PluginState;
import com.cenotelabs.lockpoint.locks.LockHelper;
import com.cenotelabs.lockpoint.locks.LockManager;
import com.cenotelabs.lockpoint.r;
import com.cenotelabs.lockpoint.services.LockpointConfluencePermissionService;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import com.cenotelabs.lockpoint.util.LockpointPluginContainerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverrideRemoveAttachmentAction
extends RemoveAttachedFileAction {
    private static final Logger a = LoggerFactory.getLogger(OverrideRemoveAttachmentAction.class);
    private LockpointServletActionContext lockpointServletActionContext;
    private SpaceAttributesManager spaceAttributesManager;
    private LockService lockService;
    private LockManager lockManager;
    private LockHelper lockHelper;
    private PluginState pluginState;
    private LockpointConfluencePermissionService lockpointConfluencePermissionService;

    public void setSpaceAttributesManager(SpaceAttributesManager spaceAttributesManager) {
        this.spaceAttributesManager = spaceAttributesManager;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public void setLockHelper(LockHelper lockHelper) {
        this.lockHelper = lockHelper;
    }

    public void setPluginState(PluginState pluginState) {
        this.pluginState = pluginState;
    }

    public void setLockpointPermissionService(LockpointConfluencePermissionService lockpointConfluencePermissionService) {
        this.lockpointConfluencePermissionService = lockpointConfluencePermissionService;
    }

    private void a() {
        LockpointPluginContainerManager lockpointPluginContainerManager = LockpointPluginContainerManager.getInstance();
        this.spaceAttributesManager = lockpointPluginContainerManager.getComponent(SpaceAttributesManager.class);
        this.lockService = lockpointPluginContainerManager.getComponent(LockService.class);
        this.lockManager = lockpointPluginContainerManager.getComponent(LockManager.class);
        this.lockHelper = lockpointPluginContainerManager.getComponent(LockHelper.class);
        this.pluginState = lockpointPluginContainerManager.getComponent(PluginState.class);
        this.lockpointConfluencePermissionService = lockpointPluginContainerManager.getComponent(LockpointConfluencePermissionService.class);
    }

    private LockpointServletActionContext b() {
        if (this.lockpointServletActionContext == null) {
            this.lockpointServletActionContext = LockpointPluginContainerManager.getInstance().getComponent(LockpointServletActionContext.class);
        }
        return this.lockpointServletActionContext;
    }

    private Boolean c() {
        r r2;
        Attachment attachment = this.getAttachment();
        if (attachment == null) {
            return Boolean.FALSE;
        }
        try {
            r2 = this.lockService.getLock(attachment);
        }
        catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
            return Boolean.FALSE;
        }
        if (this.lockHelper.isLockedByAnyone(r2) && !this.lockHelper.isLockedByCurrentUser(r2)) {
            this.addActionError("com.arsenale.plugins.lockpoint.filecheckedouttootheruser", new Object[]{attachment.getFileName(), this.lockHelper.getLockOwnerDisplayName(r2)});
            return Boolean.TRUE;
        }
        a.debug("Removing lockpoint data for {}", (Object)r2);
        this.lockManager.unlock(r2, AuthenticatedUserThreadLocal.get());
        return Boolean.FALSE;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        this.a();
        if (!this.pluginState.a()) {
            return super.execute();
        }
        if (this.spaceAttributesManager.isLockpointEnabledInSpace(this.getSpace()) && this.c().booleanValue()) {
            return "error";
        }
        return super.execute();
    }

    @PermittedMethods(value={HttpMethod.POST})
    @XsrfProtectionRequired
    public String doRemove() {
        this.a();
        if (!this.pluginState.a()) {
            return super.doRemove();
        }
        if (this.spaceAttributesManager.isLockpointEnabledInSpace(this.getSpace()) && this.c().booleanValue()) {
            this.b().getResponse().setStatus(403);
            return "error";
        }
        return super.doRemove();
    }

    public boolean isPermitted() {
        this.a();
        return this.lockpointConfluencePermissionService.hasPermission(this.getAuthenticatedUser(), Permission.REMOVE, this.getAttachment());
    }
}

