/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.webdav;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.SeraphUtils;
import com.atlassian.seraph.config.SecurityConfig;
import com.cenotelabs.lockpoint.framework.LockpointServletActionContext;
import com.cenotelabs.lockpoint.m;
import com.cenotelabs.lockpoint.webdav.FilterSession;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class WebDavAuthenticationManager {
    private static final Logger log = LoggerFactory.getLogger(WebDavAuthenticationManager.class);
    private final LockpointServletActionContext lockpointServletActionContext;

    public WebDavAuthenticationManager(LockpointServletActionContext lockpointServletActionContext) {
        this.lockpointServletActionContext = lockpointServletActionContext;
    }

    private static String[] getAuthorizationKeys(HttpServletRequest object) {
        try {
            object = object.getHeader("Authorization");
            if (object == null) {
                return null;
            }
            if (m.c((object = ((String)object).trim().split(" "))[0]) || m.c((String)object[1])) {
                return null;
            }
            byte[] byArray = Base64.getDecoder().decode(((String)object[1]).getBytes(StandardCharsets.UTF_8));
            object = byArray;
            if (byArray == null) {
                return null;
            }
            object = new String((byte[])object, StandardCharsets.UTF_8);
            int n2 = ((String)object).indexOf(58);
            String string = ((String)object).substring(0, n2);
            object = ((String)object).substring(n2 + 1);
            if (m.c(string) || m.c((String)object)) {
                return null;
            }
            log.debug("Found base64 authentication header for user={}, pass={}", (Object)string, object);
            return new String[]{string, object};
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String authenticateRequest(HttpServletRequest httpServletRequest) {
        Object object = httpServletRequest.getSession().getAttribute("com.arsenale.plugins.lockpoint.webdav");
        FilterSession filterSession = null;
        if (object instanceof FilterSession) {
            filterSession = (FilterSession)object;
        } else {
            object = AuthenticatedUserThreadLocal.getUsername();
            if (object != null) {
                filterSession = new FilterSession((String)object);
            } else {
                object = WebDavAuthenticationManager.getAuthorizationKeys(httpServletRequest);
                SecurityConfig securityConfig = SeraphUtils.getConfig((HttpServletRequest)httpServletRequest);
                if (securityConfig != null && object != null) {
                    String string = object[0];
                    object = object[1];
                    log.debug("Trying seraph authentication with user={}", (Object)string);
                    try {
                        HttpServletRequest httpServletRequest2 = this.lockpointServletActionContext.getRequest();
                        HttpServletResponse httpServletResponse = this.lockpointServletActionContext.getResponse();
                        if (securityConfig.getAuthenticator().login(httpServletRequest2, httpServletResponse, string, (String)object)) {
                            filterSession = new FilterSession(string);
                            log.debug("Created new session with Seraph authenticator for {}", (Object)string);
                        }
                    }
                    catch (Exception exception) {
                        filterSession = null;
                    }
                }
            }
        }
        if (filterSession == null) {
            return null;
        }
        httpServletRequest.getSession().setAttribute("com.arsenale.plugins.lockpoint.webdav", (Object)filterSession);
        return filterSession.a();
    }
}

