/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.cenotelabs.lockpoint.integration.LockpointIntegrationService;
import com.cenotelabs.lockpoint.integration.ServiceResult;
import com.cenotelabs.lockpoint.rest.LockpointAttachmentRestResource;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/content")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LockpointContentRestResource {
    private static final Logger log = LoggerFactory.getLogger(LockpointAttachmentRestResource.class);
    private LockpointIntegrationService lockpointIntegrationService;

    @Inject
    public LockpointContentRestResource(LockpointIntegrationService lockpointIntegrationService) {
        this.lockpointIntegrationService = lockpointIntegrationService;
    }

    @GET
    @AnonymousAllowed
    @AnonymousSiteAccess
    @Path(value="/{pageid}/attachment/{filename}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json", "text/html", "text/plain", "application/xml", "application/atom+xml"})
    public Response getAttachmentStatus(@Context HttpServletRequest object, @PathParam(value="pageid") String string, @PathParam(value="filename") String string2) {
        long l2;
        try {
            l2 = Long.parseLong(string);
        }
        catch (Exception exception) {
            log.error("Invalid page ID: {}", (Object)string);
            return Response.serverError().build();
        }
        string2 = this.getRealFilename((HttpServletRequest)object);
        object = this.lockpointIntegrationService.getLegacyAttachmentStatus((HttpServletRequest)object, this.getCurrentUsername(), l2, string2);
        return this.buildAttachmentStatusResponse((ServiceResult)object);
    }

    private String getRealFilename(HttpServletRequest object) {
        int n2 = ((String)(object = object.getPathInfo())).lastIndexOf(47);
        if (n2 == -1) {
            throw new IllegalStateException("Could not find slash in pathInfo");
        }
        return ((String)object).substring(n2 + 1);
    }

    @POST
    @Path(value="/{pageid}/attachment/{filename}/lock")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response lockAttachment(@Context HttpServletRequest object, @PathParam(value="pageid") String string, @PathParam(value="filename") String string2) {
        long l2;
        try {
            l2 = Long.parseLong(string);
        }
        catch (Exception exception) {
            log.error("Invalid page ID: {}", (Object)string);
            return Response.serverError().build();
        }
        object = this.lockpointIntegrationService.lockAttachment((HttpServletRequest)object, this.getCurrentUsername(), "confluence", l2, string2);
        return this.buildServiceResultResponse((ServiceResult)object);
    }

    @POST
    @Path(value="/{pageid}/attachment/{filename}/unlock")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response unlockAttachment(@Context HttpServletRequest object, @PathParam(value="pageid") String string, @PathParam(value="filename") String string2) {
        long l2;
        try {
            l2 = Long.parseLong(string);
        }
        catch (Exception exception) {
            log.error("Invalid page ID: {}", (Object)string);
            return Response.serverError().build();
        }
        object = this.lockpointIntegrationService.unlockAttachment((HttpServletRequest)object, this.getCurrentUsername(), "confluence", l2, string2);
        return this.buildServiceResultResponse((ServiceResult)object);
    }

    private String getCurrentUsername() {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (confluenceUser != null) {
            return confluenceUser.getName();
        }
        return null;
    }

    private Response buildServiceResultResponse(ServiceResult serviceResult) {
        if (!serviceResult.getSuccess().booleanValue()) {
            return Response.status((int)serviceResult.getHttpStatus()).type("application/json").entity((Object)serviceResult).build();
        }
        return Response.status((int)serviceResult.getHttpStatus()).type("application/json").entity((Object)serviceResult).build();
    }

    private Response buildAttachmentStatusResponse(ServiceResult serviceResult) {
        if (!serviceResult.getSuccess().booleanValue()) {
            return Response.status((int)serviceResult.getHttpStatus()).type("application/json").entity((Object)serviceResult).build();
        }
        return Response.status((int)serviceResult.getHttpStatus()).type("application/json").entity((Object)serviceResult.getAttachmentStatus()).build();
    }
}

