/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.cenotelabs.lockpoint.L;
import com.cenotelabs.lockpoint.integration.AttachmentStatus;
import com.cenotelabs.lockpoint.integration.LockpointIntegrationService;
import com.cenotelabs.lockpoint.integration.ServiceResultImpl;
import com.cenotelabs.lockpoint.rest.transport.MultiStatusResponseTransport;
import com.cenotelabs.lockpoint.rest.transport.MultiStatusTransport;
import com.cenotelabs.lockpoint.rest.transport.RestResultWithPayload;
import com.cenotelabs.lockpoint.util.DateHelper;
import com.cenotelabs.lockpoint.util.NullAcceptingDateFormat;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/attachment")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LockpointAttachmentRestResource {
    private static final Logger log = LoggerFactory.getLogger(LockpointAttachmentRestResource.class);
    private LockpointIntegrationService lockpointIntegrationService;
    private DateHelper dateHelper;
    private static final String LOCK_MODE = "confluence";

    @Inject
    public LockpointAttachmentRestResource(LockpointIntegrationService lockpointIntegrationService, DateHelper dateHelper) {
        this.lockpointIntegrationService = lockpointIntegrationService;
        this.dateHelper = dateHelper;
    }

    @GET
    @AnonymousAllowed
    @AnonymousSiteAccess
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAttachmentStatus(@Context HttpServletRequest object, @PathParam(value="id") String string) {
        long l2;
        try {
            l2 = Long.parseLong(string);
        }
        catch (Exception exception) {
            log.error("Invalid attachment ID: {}", (Object)string);
            return Response.serverError().build();
        }
        object = this.lockpointIntegrationService.getAttachmentStatus((HttpServletRequest)object, l2);
        if (!object.getSuccess().booleanValue()) {
            return Response.status((int)object.getHttpStatus()).entity(object).build();
        }
        return Response.status((int)object.getHttpStatus()).entity((Object)object.getAttachmentStatus()).build();
    }

    @POST
    @Path(value="/{id}/lock")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response lockAttachment(@Context HttpServletRequest object, @PathParam(value="id") String string) {
        long l2;
        try {
            l2 = Long.parseLong(string);
        }
        catch (Exception exception) {
            log.error("Invalid attachment ID: {}", (Object)string);
            return Response.serverError().build();
        }
        object = this.lockpointIntegrationService.lockAttachment((HttpServletRequest)object, LOCK_MODE, l2);
        return Response.status((int)object.getHttpStatus()).entity(object).build();
    }

    @POST
    @Path(value="/{id}/unlock")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response unlockAttachment(@Context HttpServletRequest object, @PathParam(value="id") String string) {
        long l2;
        try {
            l2 = Long.parseLong(string);
        }
        catch (Exception exception) {
            log.error("Invalid attachment ID: {}", (Object)string);
            return Response.serverError().build();
        }
        object = this.lockpointIntegrationService.unlockAttachment((HttpServletRequest)object, LOCK_MODE, l2);
        return Response.status((int)object.getHttpStatus()).entity(object).build();
    }

    @POST
    @Path(value="/{id}/notify")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response lockAttachment(@Context HttpServletRequest object, @PathParam(value="id") String string, @QueryParam(value="enableNotification") Boolean bl) {
        long l2;
        try {
            l2 = Long.parseLong(string);
        }
        catch (Exception exception) {
            log.error("Invalid attachment ID: {}", (Object)string);
            return Response.serverError().build();
        }
        string = AuthenticatedUserThreadLocal.get();
        object = this.lockpointIntegrationService.enableAttachmentNotification((HttpServletRequest)object, string != null ? string.getName() : null, l2, bl);
        return Response.status((int)object.getHttpStatus()).entity(object).build();
    }

    @POST
    @Path(value="/multiStatus")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response postMultiStatus(@Context HttpServletRequest object, MultiStatusTransport multiStatusTransport) {
        object = L.b("REST postMultiStatus");
        try {
            MultiStatusResponseTransport multiStatusResponseTransport = new MultiStatusResponseTransport();
            NullAcceptingDateFormat nullAcceptingDateFormat = this.dateHelper.getDateTimeFormatForUser(AuthenticatedUserThreadLocal.get());
            multiStatusTransport.getAttachmentIds().forEach(l2 -> {
                try {
                    nullAcceptingDateFormat = this.lockpointIntegrationService.getExpressAttachmentStatus((long)l2, nullAcceptingDateFormat);
                    if (nullAcceptingDateFormat == null) {
                        multiStatusResponseTransport.addError((long)l2);
                        return;
                    }
                    multiStatusResponseTransport.addAttachment((AttachmentStatus)((Object)nullAcceptingDateFormat));
                }
                catch (Throwable throwable) {
                    log.error("Caught error requesting status for attachmentId " + l2, throwable);
                    multiStatusResponseTransport.addError((long)l2);
                }
            });
            multiStatusTransport = Response.status((int)ServiceResultImpl.STATUS_OK).entity(new RestResultWithPayload<MultiStatusResponseTransport>(multiStatusResponseTransport)).build();
            return multiStatusTransport;
        }
        finally {
            if (object != null) {
                object.close();
            }
        }
    }
}

