/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.cenotelabs.lockpoint.A;
import com.cenotelabs.lockpoint.activeobjects.models.Template;
import com.cenotelabs.lockpoint.i18n.LanguageHelper;
import com.cenotelabs.lockpoint.licensing.SimpleLicenseManager;
import com.cenotelabs.lockpoint.model.EmailTemplate;
import com.cenotelabs.lockpoint.rest.LockpointSpaceRestResource;
import com.cenotelabs.lockpoint.rest.RestUtil;
import com.cenotelabs.lockpoint.rest.transport.AdminFeaturesResponseTransport;
import com.cenotelabs.lockpoint.rest.transport.AdminFeaturesTransport;
import com.cenotelabs.lockpoint.rest.transport.LanguageTransport;
import com.cenotelabs.lockpoint.rest.transport.LanguagesTransport;
import com.cenotelabs.lockpoint.rest.transport.RestResultWithPayload;
import com.cenotelabs.lockpoint.rest.transport.SpaceTemplatesTransport;
import com.cenotelabs.lockpoint.rest.transport.SpaceTimeoutsTransport;
import com.cenotelabs.lockpoint.services.LockpointConfluencePermissionService;
import com.cenotelabs.lockpoint.settings.LockpointGlobalSettingsManager;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin")
@WebSudoRequired
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LockpointAdminRestResource {
    private static final Logger log = LoggerFactory.getLogger(LockpointSpaceRestResource.class);
    private final LockpointGlobalSettingsManager globalSettingsManager;
    private final LockpointConfluencePermissionService lockpointConfluencePermissionService;
    private final I18nResolver i18nResolver;
    private final SpaceAttributesManager spaceAttributesManager;
    private final SimpleLicenseManager simpleLicenseManager;
    private final LanguageHelper languageHelper;

    @Inject
    public LockpointAdminRestResource(@ComponentImport I18nResolver i18nResolver, LockpointConfluencePermissionService lockpointConfluencePermissionService, SpaceAttributesManager spaceAttributesManager, LanguageHelper languageHelper, LockpointGlobalSettingsManager lockpointGlobalSettingsManager, SimpleLicenseManager simpleLicenseManager) {
        this.globalSettingsManager = lockpointGlobalSettingsManager;
        this.lockpointConfluencePermissionService = lockpointConfluencePermissionService;
        this.i18nResolver = i18nResolver;
        this.spaceAttributesManager = spaceAttributesManager;
        this.languageHelper = languageHelper;
        this.simpleLicenseManager = simpleLicenseManager;
    }

    @GET
    @Path(value="/languages")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getLanguages() {
        Object object = this.languageHelper.getSupportedLanguages();
        String string = this.languageHelper.getLanguageTagForUser(AuthenticatedUserThreadLocal.get());
        object = new LanguagesTransport(string, (List<LanguageTransport>)object);
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<Object>(object)).build();
    }

    @GET
    @Path(value="/features")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAdminFeatures() {
        this.verifyAdminPermissions(false);
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<AdminFeaturesResponseTransport>(this.generateAdminFeaturesResponse())).build();
    }

    @PUT
    @Path(value="/features")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setAdminFeatures(AdminFeaturesTransport object) {
        this.verifyAdminPermissions(true);
        log.debug("Set admin permissions: {}", object);
        if (((AdminFeaturesTransport)object).isSmartLocking() != null) {
            this.globalSettingsManager.setPermitUploadWithoutLock(((AdminFeaturesTransport)object).isSmartLocking());
        }
        if (((AdminFeaturesTransport)object).isShowAttachmentOwners() != null) {
            this.globalSettingsManager.setShowAttachmentOwners(((AdminFeaturesTransport)object).isShowAttachmentOwners());
        }
        if (((AdminFeaturesTransport)object).getDefaultSpaceEnabled() != null) {
            this.spaceAttributesManager.setDefaultLockpointEnabled(((AdminFeaturesTransport)object).getDefaultSpaceEnabled());
        }
        object = this.i18nResolver.getText("com.arsenale.plugins.lockpoint.systemsettings.settingsupdated");
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<AdminFeaturesResponseTransport>(this.generateAdminFeaturesResponse(), (String)object)).build();
    }

    @GET
    @Path(value="/timeouts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getTimeouts() {
        this.verifyAdminPermissions(false);
        SpaceTimeoutsTransport spaceTimeoutsTransport = this.spaceAttributesManager.getDefaultTimeouts();
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<SpaceTimeoutsTransport>(spaceTimeoutsTransport)).build();
    }

    @PUT
    @Path(value="/timeouts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setTimeouts(SpaceTimeoutsTransport object) {
        this.verifyAdminPermissions(true);
        this.spaceAttributesManager.setDefaultTimeouts((SpaceTimeoutsTransport)object);
        object = this.i18nResolver.getText("com.arsenale.plugins.lockpoint.edittimeouts.timeoutsupdated");
        SpaceTimeoutsTransport spaceTimeoutsTransport = this.spaceAttributesManager.getDefaultTimeouts();
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<SpaceTimeoutsTransport>(spaceTimeoutsTransport, (String)object)).build();
    }

    @GET
    @Path(value="/templates/{language}/{type}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getTemplates(@PathParam(value="language") String object, @PathParam(value="type") String string) {
        this.verifyAdminPermissions(false);
        object = this.spaceAttributesManager.getDefaultTemplate((String)object, this.typeToTemplateType(string));
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<Object>(object)).build();
    }

    @PUT
    @Path(value="/templates/{language}/{type}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setTemplates(@PathParam(value="language") String string, @PathParam(value="type") String object, EmailTemplate emailTemplate) {
        this.verifyAdminPermissions(true);
        object = this.typeToTemplateType((String)object);
        this.spaceAttributesManager.setDefaultTemplate(string, (Template.Type)((Object)object), emailTemplate);
        string = this.i18nResolver.getText("com.arsenale.plugins.lockpoint.editemailtemplates.updatedOne");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new A(string)).build();
    }

    @DELETE
    @Path(value="/templates/{language}/{type}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response revertTemplates(@PathParam(value="language") String string, @PathParam(value="type") String object) {
        this.verifyAdminPermissions(true);
        object = this.typeToTemplateType((String)object);
        this.spaceAttributesManager.revertDefaultTemplate(string, (Template.Type)((Object)object));
        string = this.i18nResolver.getText("com.arsenale.plugins.lockpoint.editemailtemplates.updatedOne");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)new A(string)).build();
    }

    @PUT
    @Path(value="/globalTemplates/{type}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setGlobalTemplates(@PathParam(value="type") String string, EmailTemplate emailTemplate) {
        return this.setTemplates("GLOBAL", string, emailTemplate);
    }

    @DELETE
    @Path(value="/globalTemplates/{type}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response revertGlobalTemplates(@PathParam(value="type") String string) {
        return this.revertTemplates("GLOBAL", string);
    }

    private int countTemplates(SpaceTemplatesTransport spaceTemplatesTransport) {
        return (spaceTemplatesTransport.getWarning() != null ? 1 : 0) + (spaceTemplatesTransport.getUnlock() != null ? 1 : 0) + (spaceTemplatesTransport.getNotify() != null ? 1 : 0);
    }

    private AdminFeaturesResponseTransport generateAdminFeaturesResponse() {
        AdminFeaturesTransport adminFeaturesTransport = new AdminFeaturesTransport().setDefaultSpaceEnabled(this.spaceAttributesManager.getDefaultLockpointEnabled()).setShowAttachmentOwners(this.globalSettingsManager.getShowAttachmentOwners()).setSmartLocking(this.globalSettingsManager.getPermitUploadWithoutLock());
        return new AdminFeaturesResponseTransport(adminFeaturesTransport, this.simpleLicenseManager.licenseIsValid());
    }

    private void verifyAdminPermissions(boolean bl) {
        if (this.lockpointConfluencePermissionService.isConfluenceAdministrator(AuthenticatedUserThreadLocal.get())) {
            return;
        }
        RestUtil.throwNoAccessError(this.i18nResolver, bl);
    }

    private Template.Type typeToTemplateType(String string) {
        if (string.equals("warning")) {
            return Template.Type.WARNING;
        }
        if (string.equals("unlock")) {
            return Template.Type.UNLOCK;
        }
        if (string.equals("notify")) {
            return Template.Type.NOTIFY;
        }
        throw new IllegalArgumentException("Invalid template type: " + string);
    }
}

