/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.migration;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.cenotelabs.lockpoint.activeobjects.models.LockModel;
import com.cenotelabs.lockpoint.activeobjects.services.LockService;
import com.cenotelabs.lockpoint.m;
import com.cenotelabs.lockpoint.q;
import com.cenotelabs.lockpoint.s;
import com.cenotelabs.lockpoint.services.LockpointSpaceService;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AttachmentDataCollector {
    private static final Logger a = LoggerFactory.getLogger(AttachmentDataCollector.class);
    private final TransactionTemplate b;
    private final LockService c;
    private final LockpointSpaceService d;
    private final SpaceAttributesManager e;

    @Inject
    public AttachmentDataCollector(@ComponentImport TransactionTemplate transactionTemplate, LockService lockService, LockpointSpaceService lockpointSpaceService, SpaceAttributesManager spaceAttributesManager) {
        this.b = transactionTemplate;
        this.c = lockService;
        this.d = lockpointSpaceService;
        this.e = spaceAttributesManager;
    }

    public JsonObject migrateLocks(s s2, Set<String> set) {
        JsonObject jsonObject = new JsonObject();
        Object object = (List)this.b.execute(this.c::getAllLocks);
        Space space = null;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (q)object.next();
            long l2 = ((q)object2).a().getSpace().getId();
            if (!set.contains(Long.toString(l2))) continue;
            if (space == null || space.getId() != l2) {
                space = (Space)this.b.execute(() -> this.a((q)object2));
                a.debug("Now iterating over locks in space {}", (Object)space.getKey());
            }
            Space space2 = space;
            if ((space2 = (JsonObject)this.b.execute(() -> this.a(space2, s2, (q)object2))) == null) continue;
            long l3 = ((q)object2).c();
            if ((object2 = s2.a(l3)) != null) {
                jsonObject.add((String)object2, (JsonValue)space2);
                continue;
            }
            a.error("Could not map attachment ID {} to cloud", (Object)l3);
        }
        return jsonObject;
    }

    private JsonObject a(s s2, q q2) {
        a.info("Migrating data for attachmentId {}", (Object)q2.c());
        JsonObject jsonObject = new JsonObject();
        LockModel lockModel = q2.b();
        String string = lockModel.getNotifications();
        String string2 = s2.a(lockModel.getOwner());
        if (string2 == null) {
            a.error("Skipping lock migration: could not map owner for attachmentId {} of {}", (Object)q2.c(), (Object)lockModel.getOwner());
            return null;
        }
        jsonObject.add("owner", string2);
        jsonObject.add("lockDate", lockModel.getLockedDate());
        jsonObject.add("notifications", (JsonValue)(string != null ? AttachmentDataCollector.a(s2, string) : Json.array()));
        jsonObject.add("warningSent", lockModel.isSentWarningEmail());
        return jsonObject;
    }

    private static JsonArray a(s s2, String object) {
        object = Arrays.asList(((String)object).split(LockService.a));
        return m.a(s2.a((List<String>)object));
    }

    private /* synthetic */ JsonObject a(Space space, s s2, q q2) {
        if (!this.e.isLockpointEnabledInSpace(space)) {
            return null;
        }
        return this.a(s2, q2);
    }

    private /* synthetic */ Space a(q q2) {
        return this.d.getSpaceById(q2.e().getId());
    }
}

