/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.mail;

import com.atlassian.confluence.mail.template.AbstractMailNotificationQueueItem;
import com.atlassian.mail.Email;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.user.User;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailQueueItemFromContent
extends AbstractMailNotificationQueueItem
implements MailQueueItem {
    private static final Logger log = LoggerFactory.getLogger(MailQueueItemFromContent.class);
    private String renderedSubject;
    private final String email;
    private final Map<String, Object> context = new HashMap<String, Object>();

    public MailQueueItemFromContent(User user, String string, String string2) {
        super(string);
        this.setSubject(string2);
        this.email = user.getEmail();
    }

    public MailQueueItemFromContent(String string, String string2, String string3) {
        super(string2);
        this.setSubject(string3);
        this.email = string;
    }

    public void addVelocityContextParam(String string, Object object) {
        super.addVelocityContextParam(string, object);
        this.context.put(string, object);
    }

    public Object removeVelocityContextParam(String string) {
        super.removeVelocityContextParam(string);
        return this.context.remove(string);
    }

    public void clearContext() {
        super.clearContext();
        this.context.clear();
    }

    public Object getVelocityContextParam(String string) {
        super.getVelocityContextParam(string);
        return this.context.get(string);
    }

    private String getLockpointRenderedContent(String string) {
        if (string == null) {
            return null;
        }
        for (Map.Entry<String, Object> entry : this.context.entrySet()) {
            String string2 = entry.getValue() != null ? entry.getValue().toString() : "";
            string = string.replaceAll(Pattern.quote("$" + entry.getKey()), Matcher.quoteReplacement(string2));
        }
        return string;
    }

    public void render() {
        this.renderedSubject = this.getLockpointRenderedContent(this.getSubject());
        this.addVelocityContextParam("subject", this.renderedSubject);
        this.body = this.getLockpointRenderedContent(this.getTemplateContent());
        this.clearContext();
    }

    protected Email createMailObject() {
        Email email = new Email(this.email);
        email.setEncoding("UTF-8");
        email.setSubject(this.renderedSubject);
        email.setBody(this.body);
        email.setMimeType("text/plain");
        this.setLastError(null);
        return email;
    }

    protected String getMimeType() {
        return "text/plain";
    }
}

