/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.locks;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.cenotelabs.lockpoint.licensing.LicenseManagerReason;
import com.cenotelabs.lockpoint.licensing.SimpleLicenseManager;
import com.cenotelabs.lockpoint.m;
import com.cenotelabs.lockpoint.o;
import com.cenotelabs.lockpoint.q;
import com.cenotelabs.lockpoint.r;
import com.cenotelabs.lockpoint.settings.LockpointGlobalSettingsManager;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import com.cenotelabs.lockpoint.util.DateHelper;
import com.cenotelabs.lockpoint.util.NullAcceptingDateFormat;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LockHelper {
    private static final Logger a = LoggerFactory.getLogger(LockHelper.class);
    private final SpaceAttributesManager b;
    private final UserAccessor c;
    private final LockpointGlobalSettingsManager d;
    private final I18nResolver e;
    private final SimpleLicenseManager f;
    private final DateHelper g;

    @Inject
    public LockHelper(SpaceAttributesManager spaceAttributesManager, UserAccessor userAccessor, LockpointGlobalSettingsManager lockpointGlobalSettingsManager, I18nResolver i18nResolver, SimpleLicenseManager simpleLicenseManager, DateHelper dateHelper) {
        this.b = spaceAttributesManager;
        this.c = userAccessor;
        this.d = lockpointGlobalSettingsManager;
        this.e = i18nResolver;
        this.f = simpleLicenseManager;
        this.g = dateHelper;
    }

    public boolean isActiveInSpace(q q2) {
        return (q2 = q2.e()) != null && this.b.isLockpointEnabledInSpace((Space)q2);
    }

    public boolean isLockedByAnyone(q q2) {
        return q2.h() && this.isActiveInSpace(q2);
    }

    public boolean isLockedWithWebDav(q q2) {
        return q2.h() && q2.b().isLockedWithWebDav() && this.isActiveInSpace(q2);
    }

    public String getLockOwner(q q2) {
        if (q2.h() && this.isActiveInSpace(q2)) {
            return q2.b().getOwner();
        }
        return null;
    }

    public ConfluenceUser getLockOwnerUser(q object) {
        if ((object = this.getLockOwner((q)object)) != null) {
            return this.c.getExistingUserByKey(new UserKey((String)object));
        }
        return null;
    }

    public String getLockOwnerDisplayName(q q2) {
        ConfluenceUser confluenceUser = this.getLockOwnerUser(q2);
        if (confluenceUser != null) {
            return confluenceUser.getFullName();
        }
        return this.getLockOwner(q2);
    }

    public boolean isLockedByCurrentUser(q q2) {
        return this.isLockedByGivenUser(q2, AuthenticatedUserThreadLocal.get());
    }

    public boolean isLockedByGivenUser(q object, ConfluenceUser object2) {
        if (object2 == null) {
            return false;
        }
        if (m.a((String)(object2 = object2.getKey().getStringValue()))) {
            return false;
        }
        object = this.getLockOwner((q)object);
        return ((String)object2).equals(object);
    }

    public boolean isLockedByAnotherUser(q q2) {
        return this.isLockedByAnotherUser(q2, AuthenticatedUserThreadLocal.get());
    }

    public boolean isLockedByAnotherUser(q q2, ConfluenceUser confluenceUser) {
        boolean bl = this.isLockedByGivenUser(q2, confluenceUser);
        return !bl && this.isLockedByAnyone(q2);
    }

    public r isUploadAllowed(q object, ConfluenceUser object2, boolean bl) {
        if (!this.isActiveInSpace((q)object)) {
            return r.a;
        }
        Object object3 = this.getLicenseReason();
        if (object3 != LicenseManagerReason.a) {
            return r.a;
        }
        object3 = ((q)object).d();
        if (!this.isLockedByAnyone((q)object)) {
            if (bl || this.d.getPermitUploadWithoutLock()) {
                return r.a;
            }
            object2 = "com.arsenale.plugins.lockpoint.filemustbecheckedout";
            object = this.e.getText((String)object2, new Serializable[]{PlainTextToHtmlConverter.encodeHtmlEntities((String)object3)});
            String string = this.e.getText((String)object2, new Serializable[]{object3});
            return new r(false, (String)object, string);
        }
        if (!this.isLockedByGivenUser((q)object, (ConfluenceUser)object2)) {
            object2 = "com.arsenale.plugins.lockpoint.filecheckedouttootheruser";
            object = this.getLockOwnerDisplayName((q)object);
            String string = this.e.getText((String)object2, (Serializable[])PlainTextToHtmlConverter.encodeHtmlEntities((String[])new String[]{object3, object}));
            object = this.e.getText((String)object2, new Serializable[]{object3, object});
            return new r(false, string, (String)object);
        }
        return r.a;
    }

    public String renderLockWarningAsHtml(q q2) {
        try {
            String string = q2.d();
            String string2 = this.getUserDisplayStringForLock(q2);
            String string3 = this.getFormattedLockDate(q2);
            string2 = this.e.getText("com.arsenale.plugins.lockpoint.tooltip.lockedbysentence", new Serializable[]{string2, string3});
            return "<div class=\"lockpoint-warning-nof\"><div class=\"lockpointicon lockedbysomeoneelse\">&nbsp;\n</div>\n<div class=\"lpinnerattach\">\n<span><strong>" + HtmlUtil.htmlEncode((String)string) + "</strong> \n" + string2 + "\n</span>\n</div>\n</div><br/>";
        }
        catch (Exception exception) {
            a.error("Could not render attachment warning for " + q2.a(), (Throwable)exception);
            return "*ERROR*";
        }
    }

    public String getLockedByOtherUserMessage(q q2) {
        return this.e.getText("com.arsenale.plugins.lockpoint.filecheckedouttootheruser", new Serializable[]{q2.d(), this.getLockOwnerDisplayName(q2)});
    }

    public LicenseManagerReason getLicenseReason() {
        return this.f.getLicenseReason(Locale.getDefault(), true);
    }

    public o getLicenseStatus() {
        return this.f.getLicenseStatus(Locale.getDefault(), true);
    }

    public Date getLockDate(q q2) {
        if (q2.b().isLocked()) {
            return new Date(q2.b().getLockedDate());
        }
        return null;
    }

    public String getFormattedLockDate(q object) {
        NullAcceptingDateFormat nullAcceptingDateFormat = this.g.getDateTimeFormatForUser(AuthenticatedUserThreadLocal.get());
        object = nullAcceptingDateFormat.format(this.getLockDate((q)object));
        if (object != null) {
            return object;
        }
        return "";
    }

    public String getUserDisplayStringForLock(q object) {
        if ((object = this.getLockOwnerUser((q)object)) == null) {
            return "";
        }
        String string = HtmlUtil.htmlEncode((String)object.getFullName());
        if (!m.a((String)(object = object.getEmail()))) {
            return "<a href=\"mailto:" + HtmlUtil.htmlEncode((String)object) + "\">" + string + "</a>";
        }
        return string;
    }
}

