/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.filters;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.cenotelabs.lockpoint.activeobjects.exceptions.LockpointAttachmentNotFoundException;
import com.cenotelabs.lockpoint.activeobjects.services.LockService;
import com.cenotelabs.lockpoint.filters.AttachmentPathStringBasedServletFilter;
import com.cenotelabs.lockpoint.locks.LockHelper;
import com.cenotelabs.lockpoint.q;
import com.cenotelabs.lockpoint.services.LockpointConfluencePermissionService;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousSiteAccess
public class DeleteAttachmentServletFilter
extends AttachmentPathStringBasedServletFilter {
    private static final Logger a = LoggerFactory.getLogger(DeleteAttachmentServletFilter.class);
    private final TransactionTemplate b;
    private final LockService c;
    private final LockHelper d;
    private final ContentService e;

    @Inject
    public DeleteAttachmentServletFilter(@ComponentImport TransactionTemplate transactionTemplate, @ComponentImport ContentService contentService, LockpointConfluencePermissionService lockpointConfluencePermissionService, LockService lockService, LockHelper lockHelper) {
        super(lockpointConfluencePermissionService, false);
        this.b = transactionTemplate;
        this.c = lockService;
        this.d = lockHelper;
        this.e = contentService;
    }

    @Override
    public q getAttachmentFromPath(String object, HttpServletRequest object2) {
        try {
            long l2;
            if (!((String)object).startsWith("/rest/api/content/")) {
                return null;
            }
            if (!"DELETE".equals(object2.getMethod())) {
                return null;
            }
            object2 = ((String)object).substring(18);
            try {
                l2 = Long.parseLong((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                a.error("Invalid attachment ID specified: {}", object);
                return null;
            }
            object = (Optional)this.b.execute(() -> this.e.find(new Expansion[0]).withId(ContentId.of((long)l2)).fetch());
            if (!((Optional)object).isPresent()) {
                return null;
            }
            if ((object = (Content)((Optional)object).get()).getType() != ContentType.ATTACHMENT) {
                return null;
            }
            return (q)this.b.execute(() -> {
                try {
                    return this.c.getLock(l2);
                }
                catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
                    a.error("Could not find Lockpoint attachment for attachment ID {}", (Object)l2);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            a.error("Caught exception trying to shim attachment deletion request", throwable);
            return null;
        }
    }

    @Override
    public void doFilter(@Nonnull q q2, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        a.debug("Validating delete request for user {} on URI {} of contentId {}", new Object[]{confluenceUser, httpServletRequest.getRequestURI(), q2.c()});
        boolean bl = (Boolean)this.b.execute(() -> this.d.isLockedByAnotherUser(q2));
        if (!bl) {
            a.debug("Permitting deletion of attachment {} for user {}", (Object)q2.c(), (Object)confluenceUser);
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        this.b.execute(() -> {
            a.debug("Denying attachment delete {} for user {}; file is already locked by user: {}", new Object[]{q2.c(), confluenceUser, this.d.getLockOwner(q2)});
            return null;
        });
        this.sendErrorResponse(httpServletResponse, 409, "Attachment is locked by another user.");
    }
}

