/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.c2;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.cenotelabs.lockpoint.activeobjects.exceptions.LockpointAttachmentNotFoundException;
import com.cenotelabs.lockpoint.activeobjects.services.LockService;
import com.cenotelabs.lockpoint.filters.AttachmentPathStringBasedServletFilter;
import com.cenotelabs.lockpoint.locks.LockHelper;
import com.cenotelabs.lockpoint.q;
import com.cenotelabs.lockpoint.r;
import com.cenotelabs.lockpoint.services.LockpointConfluencePermissionService;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class TokenAuthServletFilter
extends AttachmentPathStringBasedServletFilter {
    private static final Logger a = LoggerFactory.getLogger(TokenAuthServletFilter.class);
    private final TransactionTemplate b;
    private final LockService c;
    private final LockHelper d;

    @Inject
    public TokenAuthServletFilter(@ComponentImport TransactionTemplate transactionTemplate, LockpointConfluencePermissionService lockpointConfluencePermissionService, LockService lockService, LockHelper lockHelper) {
        super(lockpointConfluencePermissionService, true);
        this.b = transactionTemplate;
        this.c = lockService;
        this.d = lockHelper;
    }

    @Override
    public q getAttachmentFromPath(String object, HttpServletRequest object2) {
        long l2;
        object2 = object;
        if (!object.startsWith("/rest/token-auth/api/content/")) {
            return null;
        }
        object = object.substring(29);
        if (!(((String[])(object = object.split("/"))).length == 5 && "child".equals(object[1]) && "attachment".equals(object[2]) && "data".equals(object[4]))) {
            a.warn("Invalid filter URI: {}", object2);
            return null;
        }
        object = object[3];
        try {
            l2 = Long.parseLong((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            a.error("Invalid attachment ID specified: {}", object2);
            return null;
        }
        try {
            return this.c.getLock(l2);
        }
        catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
            a.error("Could not find Lockpoint attachment for attachment ID {}", (Object)l2);
            return null;
        }
    }

    @Override
    public void doFilter(@Nonnull q q2, HttpServletRequest object, HttpServletResponse httpServletResponse, FilterChain filterChain) {
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        a.debug("Validating request for user {} on URI {} of attachment {}", new Object[]{confluenceUser, object.getRequestURI(), q2.c()});
        r r2 = (r)this.b.execute(() -> this.d.isUploadAllowed(q2, confluenceUser, false));
        if (r2.a()) {
            a.debug("Permitting attachment {} for user {}", (Object)q2.c(), (Object)confluenceUser);
            filterChain.doFilter((ServletRequest)object, (ServletResponse)httpServletResponse);
            return;
        }
        object = r2.c();
        this.b.execute(() -> this.a(q2, confluenceUser, httpServletResponse, (String)object));
    }

    private /* synthetic */ Object a(q q2, ConfluenceUser confluenceUser, HttpServletResponse httpServletResponse, String string) {
        a.debug("Denying attachment {} for user {}; file is {} (locking user: {})", new Object[]{q2.c(), confluenceUser, this.d.isLockedByAnyone(q2) ? "locked" : "not locked", this.d.getLockOwner(q2)});
        this.sendErrorResponse(httpServletResponse, 409, string);
        return null;
    }
}

