/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.actions;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.pages.actions.TinyUrlAware;
import com.atlassian.confluence.pages.actions.ViewPageAttachmentsAction;
import com.atlassian.confluence.security.CaptchaAware;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.ParameterSafe;
import com.atlassian.xwork.PermittedMethods;
import com.atlassian.xwork.RequireSecurityToken;
import com.atlassian.xwork.XsrfTokenGenerator;
import com.cenotelabs.lockpoint.activeobjects.exceptions.LockpointAttachmentNotFoundException;
import com.cenotelabs.lockpoint.activeobjects.services.LockService;
import com.cenotelabs.lockpoint.framework.DeferredMessageManager;
import com.cenotelabs.lockpoint.framework.LockpointMultiPartRequestHelper;
import com.cenotelabs.lockpoint.framework.LockpointServletActionContext;
import com.cenotelabs.lockpoint.lifecycle.PluginState;
import com.cenotelabs.lockpoint.locks.LockHelper;
import com.cenotelabs.lockpoint.locks.LockManager;
import com.cenotelabs.lockpoint.m;
import com.cenotelabs.lockpoint.q;
import com.cenotelabs.lockpoint.r;
import com.cenotelabs.lockpoint.services.LockpointAttachmentService;
import com.cenotelabs.lockpoint.services.LockpointConfluencePermissionService;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import com.cenotelabs.lockpoint.util.LockpointPluginContainerManager;
import com.cenotelabs.lockpoint.util.LockpointUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverrideViewPageAttachmentsAction
extends ViewPageAttachmentsAction
implements PageAware,
TinyUrlAware,
CaptchaAware {
    private AbstractPage page;
    private String redirectTarget;
    private String fileName;
    private static final Logger a = LoggerFactory.getLogger(OverrideViewPageAttachmentsAction.class);
    private LockpointUtil lockpointUtil;
    private Boolean forcedCheckin = Boolean.FALSE;
    private XsrfTokenGenerator xsrfTokenGenerator;
    private DeferredMessageManager deferredMessageManager;
    private SpaceAttributesManager spaceAttributesManager;
    private final List<Long> attachmentsToLockOrUnlock = new ArrayList<Long>();
    private LockpointServletActionContext lockpointServletActionContext;
    private LockpointMultiPartRequestHelper lockpointMultiPartRequestHelper;
    private LockService lockService;
    private LockManager lockManager;
    private LockHelper lockHelper;
    private PluginState pluginState;
    private LockpointAttachmentService lockpointAttachmentService;
    private LockpointConfluencePermissionService lockpointConfluencePermissionService;

    public void setXsrfTokenGenerator(XsrfTokenGenerator xsrfTokenGenerator) {
        this.xsrfTokenGenerator = xsrfTokenGenerator;
    }

    public void setLockpointUtil(LockpointUtil lockpointUtil) {
        this.lockpointUtil = lockpointUtil;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public void setLockHelper(LockHelper lockHelper) {
        this.lockHelper = lockHelper;
    }

    public void setSpaceAttributesManager(SpaceAttributesManager spaceAttributesManager) {
        this.spaceAttributesManager = spaceAttributesManager;
    }

    public void setDeferredMessageManager(DeferredMessageManager deferredMessageManager) {
        this.deferredMessageManager = deferredMessageManager;
    }

    public void setPluginState(PluginState pluginState) {
        this.pluginState = pluginState;
    }

    public void setLockpointAttachmentService(LockpointAttachmentService lockpointAttachmentService) {
        this.lockpointAttachmentService = lockpointAttachmentService;
    }

    public void setLockpointPermissionService(LockpointConfluencePermissionService lockpointConfluencePermissionService) {
        this.lockpointConfluencePermissionService = lockpointConfluencePermissionService;
    }

    private void a() {
        LockpointPluginContainerManager lockpointPluginContainerManager = LockpointPluginContainerManager.getInstance();
        this.lockpointUtil = lockpointPluginContainerManager.getComponent(LockpointUtil.class);
        this.lockService = lockpointPluginContainerManager.getComponent(LockService.class);
        this.lockManager = lockpointPluginContainerManager.getComponent(LockManager.class);
        this.lockHelper = lockpointPluginContainerManager.getComponent(LockHelper.class);
        this.spaceAttributesManager = lockpointPluginContainerManager.getComponent(SpaceAttributesManager.class);
        this.deferredMessageManager = lockpointPluginContainerManager.getComponent(DeferredMessageManager.class);
        this.lockpointMultiPartRequestHelper = lockpointPluginContainerManager.getComponent(LockpointMultiPartRequestHelper.class);
        this.lockpointServletActionContext = lockpointPluginContainerManager.getComponent(LockpointServletActionContext.class);
        this.pluginState = lockpointPluginContainerManager.getComponent(PluginState.class);
        this.lockpointAttachmentService = lockpointPluginContainerManager.getComponent(LockpointAttachmentService.class);
        this.lockpointConfluencePermissionService = lockpointPluginContainerManager.getComponent(LockpointConfluencePermissionService.class);
    }

    @ParameterSafe
    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    @ParameterSafe
    public void setForced(Boolean bl) {
        this.forcedCheckin = bl;
    }

    public Boolean getForced() {
        return this.forcedCheckin;
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String doDefault() {
        this.a();
        if (!this.pluginState.a()) {
            return super.doDefault();
        }
        Iterator<String> iterator = this.deferredMessageManager.getAndClearDeferredErrors();
        List<String> list = this.deferredMessageManager.getAndClearDeferredNotes();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.addActionError(string);
        }
        for (String string : list) {
            this.addActionMessage(string);
        }
        return super.doDefault();
    }

    @RequireSecurityToken(value=true)
    @PermittedMethods(value={HttpMethod.POST})
    public String execute() {
        this.a();
        return super.execute();
    }

    protected void validateUpload() {
        this.a();
        if (!this.pluginState.a()) {
            super.validateUpload();
            return;
        }
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (this.spaceAttributesManager.isLockpointEnabledInSpace(this.b())) {
            Object object = this.lockpointMultiPartRequestHelper.getFilenames(super.getCurrentRequest());
            boolean bl = false;
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (String)object.next();
                try {
                    object2 = this.lockService.getLock((ContentEntityObject)this.page, (String)object2);
                    if (((r)(object2 = this.lockHelper.isUploadAllowed((q)object2, confluenceUser, false))).a()) continue;
                    this.addActionError(((r)object2).b());
                    bl = true;
                }
                catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {}
            }
            if (bl) {
                return;
            }
        }
        super.validateUpload();
    }

    @ParameterSafe
    public void setA(String stringArray) {
        String[] stringArray2 = m.a((String)stringArray, ',');
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            string = string.trim();
            try {
                this.attachmentsToLockOrUnlock.add(Long.parseLong(string));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                a.debug("Received lock request for invalid attachment ID: " + string);
            }
        }
    }

    public void setPage(AbstractPage abstractPage) {
        super.setPage(abstractPage);
        this.page = abstractPage;
    }

    public AbstractPage getPage() {
        return this.page;
    }

    public boolean isViewPermissionRequired() {
        return true;
    }

    public boolean isLatestVersionRequired() {
        return true;
    }

    public boolean isPageRequired() {
        return true;
    }

    public String getRedirectTarget() {
        this.a();
        if (this.redirectTarget != null) {
            return this.redirectTarget;
        }
        return "/pages/viewpageattachments.action?pageId=" + this.getPageId();
    }

    @ParameterSafe
    public void setOnSuccess(String string) {
        Object object;
        try {
            object = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            object = null;
        }
        if (object == null) {
            a.debug("URI failed to parse: " + string);
            this.redirectTarget = null;
            return;
        }
        String string2 = ((URI)object).getPath();
        String string3 = ((URI)object).getQuery();
        object = ((URI)object).getFragment();
        if (string2.startsWith("/lockpoint/lock.action") || string2.startsWith("/lockpoint/unlock.action") || string2.startsWith("/lockpoint/lockAll.action") || string2.startsWith("/lockpoint/unlockAll.action")) {
            return;
        }
        try {
            object = new URI(null, null, string2, string3, (String)object);
        }
        catch (URISyntaxException uRISyntaxException) {
            a.error("URI failed to parse: " + string);
            this.redirectTarget = null;
            return;
        }
        this.redirectTarget = ((URI)object).toASCIIString();
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    @RequireSecurityToken(value=true)
    public String doLock() {
        this.a();
        if (!this.pluginState.a()) {
            return "success";
        }
        Object object = AuthenticatedUserThreadLocal.get();
        if (!this.spaceAttributesManager.isLockpointEnabledInSpace(this.b())) {
            return "success";
        }
        Object object2 = this.lockpointAttachmentService.getAttachmentByFilename((ContentEntityObject)this.page, this.fileName);
        if (!this.a((Attachment)object2)) {
            OverrideViewPageAttachmentsAction overrideViewPageAttachmentsAction = this;
            overrideViewPageAttachmentsAction.addActionError(overrideViewPageAttachmentsAction.getText("com.arsenale.plugins.lockpoint.noPermissionForAction"));
            return "error";
        }
        try {
            object2 = this.lockService.getLock((ContentEntityObject)this.page, this.fileName);
            if (this.lockHelper.isLockedByAnyone((q)object2)) {
                object = this.lockHelper.isLockedByGivenUser((q)object2, (ConfluenceUser)object) ? (this.lockHelper.isLockedWithWebDav((q)object2) ? "com.arsenale.plugins.lockpoint.filealreadylockedwithwebdav" : "com.arsenale.plugins.lockpoint.filealreadylocked") : "com.arsenale.plugins.lockpoint.filecheckedouttootheruser";
                this.addActionError((String)object, new Object[]{this.fileName, this.lockHelper.getLockOwnerDisplayName((q)object2)});
                return "error";
            }
            this.lockManager.lock((q)object2, (ConfluenceUser)object, false);
            return "success";
        }
        catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
            OverrideViewPageAttachmentsAction overrideViewPageAttachmentsAction = this;
            overrideViewPageAttachmentsAction.addActionError(overrideViewPageAttachmentsAction.getText("com.arsenale.plugins.lockpoint.noPermissionForAction"));
            return "error";
        }
    }

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    @RequireSecurityToken(value=true)
    public String doUnlock() {
        this.a();
        if (!this.pluginState.a()) {
            return "success";
        }
        if (!this.spaceAttributesManager.isLockpointEnabledInSpace(this.b())) {
            return "success";
        }
        Object object = this.lockpointAttachmentService.getAttachmentByFilename((ContentEntityObject)this.page, this.fileName);
        Object object2 = AuthenticatedUserThreadLocal.get();
        if (!this.a((Attachment)object) || object2 == null) {
            OverrideViewPageAttachmentsAction overrideViewPageAttachmentsAction = this;
            overrideViewPageAttachmentsAction.addActionError(overrideViewPageAttachmentsAction.getText("com.arsenale.plugins.lockpoint.noPermissionForAction"));
            return "error";
        }
        try {
            object = this.lockService.getLock((ContentEntityObject)this.page, this.fileName);
            boolean bl = this.lockHelper.isLockedByGivenUser((q)object, (ConfluenceUser)object2);
            if (bl || this.lockHelper.isLockedByAnyone((q)object) && this.lockpointUtil.isLockpointAdministrator(AuthenticatedUserThreadLocal.get(), this.getPage().getSpace())) {
                if (bl && this.lockHelper.isLockedWithWebDav((q)object) && !this.forcedCheckin.booleanValue()) {
                    object2 = this.lockpointServletActionContext.getRequest();
                    object2 = LockpointUtil.generateCheckInOutURL(Boolean.TRUE, (HttpServletRequest)object2, (q)object, (ContentEntityObject)this.page, this.xsrfTokenGenerator, Boolean.TRUE);
                    this.addActionError("com.arsenale.plugins.lockpoint.filecheckedoutwebdav", new Object[]{this.fileName, this.lockHelper.getLockDate((q)object), object2});
                    return "error";
                }
                this.lockManager.unlock((q)object, (ConfluenceUser)object2);
                return "success";
            }
            this.addActionError("com.arsenale.plugins.lockpoint.filealreadycheckedin", new Object[]{this.fileName});
            return "error";
        }
        catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
            OverrideViewPageAttachmentsAction overrideViewPageAttachmentsAction = this;
            overrideViewPageAttachmentsAction.addActionError(overrideViewPageAttachmentsAction.getText("com.arsenale.plugins.lockpoint.noPermissionForAction"));
            return "error";
        }
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String doLockAll() {
        return this.a(true);
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String doUnlockAll() {
        return this.a(false);
    }

    private String a(boolean bl) {
        this.a();
        ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
        if (!this.pluginState.a()) {
            return "success";
        }
        if (!this.spaceAttributesManager.isLockpointEnabledInSpace(this.b())) {
            return "success";
        }
        if (!this.lockpointUtil.hasPermissionToLockUnlockAll(confluenceUser, (ContentEntityObject)this.page).booleanValue()) {
            OverrideViewPageAttachmentsAction overrideViewPageAttachmentsAction = this;
            overrideViewPageAttachmentsAction.addActionError(overrideViewPageAttachmentsAction.getText("com.arsenale.plugins.lockpoint.noPermissionForAction"));
            return "error";
        }
        for (Long l2 : this.attachmentsToLockOrUnlock) {
            a.debug("Trying to process attachmentId {}", (Object)l2);
            if (l2 == null) continue;
            try {
                q q2 = this.lockService.getLock(l2);
                if (bl && !this.lockHelper.isLockedByAnyone(q2)) {
                    this.lockManager.lock(q2, confluenceUser, false);
                    continue;
                }
                if (bl || !this.lockHelper.isLockedByGivenUser(q2, confluenceUser)) continue;
                this.lockManager.unlock(q2, confluenceUser);
            }
            catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {}
        }
        return "success";
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String doNotLocked() {
        this.addActionError("com.arsenale.plugins.lockpoint.filenotcheckedout", new Object[]{this.fileName});
        return "error";
    }

    @PermittedMethods(value={HttpMethod.GET})
    @RequireSecurityToken(value=true)
    public String doNotifyMe() {
        this.a();
        a.debug("Got request to notify for {}, file: {}", (Object)this.page, (Object)this.fileName);
        if (!this.pluginState.a()) {
            return "success";
        }
        if (!this.spaceAttributesManager.isLockpointEnabledInSpace(this.b())) {
            return "success";
        }
        try {
            q q2 = this.lockService.getLock((ContentEntityObject)this.page, this.fileName);
            if (!this.lockHelper.isLockedByAnyone(q2)) {
                this.deferredMessageManager.addDeferredError("com.arsenale.plugins.lockpoint.xwork.actions.ViewSpaceLocksAction.notcheckedout", this.fileName);
                return "success";
            }
            this.lockManager.addNotification(q2, AuthenticatedUserThreadLocal.get());
            this.deferredMessageManager.addDeferredNote("com.arsenale.plugins.lockpoint.notificationadded", this.fileName);
            return "success";
        }
        catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
            this.deferredMessageManager.addDeferredError("com.arsenale.plugins.lockpoint.filedoesnotexist", this.fileName);
            return "success";
        }
    }

    @PermittedMethods(value={HttpMethod.GET})
    @RequireSecurityToken(value=true)
    public String doCancelNotify() {
        this.a();
        a.debug("Got request to remove notification for {}, file: {}", (Object)this.page, (Object)this.fileName);
        if (!this.pluginState.a()) {
            return "success";
        }
        if (!this.spaceAttributesManager.isLockpointEnabledInSpace(this.b())) {
            return "success";
        }
        try {
            q q2 = this.lockService.getLock((ContentEntityObject)this.page, this.fileName);
            this.lockManager.removeNotification(q2, AuthenticatedUserThreadLocal.get());
            this.deferredMessageManager.addDeferredNote("com.arsenale.plugins.lockpoint.notificationcanceled", this.fileName);
            return "success";
        }
        catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
            this.deferredMessageManager.addDeferredError("com.arsenale.plugins.lockpoint.filedoesnotexist", this.fileName);
            return "success";
        }
    }

    private boolean a(Attachment attachment) {
        return attachment != null && (this.lockpointConfluencePermissionService.hasCreatePermission(this.getAuthenticatedUser(), this.page, Attachment.class) || this.lockpointConfluencePermissionService.hasPermission(this.getAuthenticatedUser(), Permission.EDIT, attachment));
    }

    private Space b() {
        if (this.page == null) {
            return null;
        }
        return this.page.getSpace();
    }
}

