/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.rest;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.cenotelabs.lockpoint.activeobjects.services.LockService;
import com.cenotelabs.lockpoint.activeobjects.services.PermissionService;
import com.cenotelabs.lockpoint.api.LockpointGlobalSettingsManager;
import com.cenotelabs.lockpoint.locks.LockHelper;
import com.cenotelabs.lockpoint.o;
import com.cenotelabs.lockpoint.rest.SpaceAwareRestResource;
import com.cenotelabs.lockpoint.rest.transport.AttachmentTransport;
import com.cenotelabs.lockpoint.rest.transport.EntityPermissionTransport;
import com.cenotelabs.lockpoint.rest.transport.RestResultWithPayload;
import com.cenotelabs.lockpoint.rest.transport.SpaceActivateTransport;
import com.cenotelabs.lockpoint.rest.transport.SpaceActivationTransport;
import com.cenotelabs.lockpoint.rest.transport.SpaceTemplatesTransport;
import com.cenotelabs.lockpoint.rest.transport.SpaceTimeoutsTransport;
import com.cenotelabs.lockpoint.services.LockpointConfluencePermissionService;
import com.cenotelabs.lockpoint.services.LockpointSpaceService;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import com.cenotelabs.lockpoint.util.LockpointUtil;
import com.cenotelabs.lockpoint.z;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/space")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LockpointSpaceRestResource
extends SpaceAwareRestResource {
    private static final Logger log = LoggerFactory.getLogger(LockpointSpaceRestResource.class);
    private final PermissionService permissionService;
    private final LocaleManager localeManager;
    private final FormatSettingsManager formatSettingsManager;
    private final UserAccessor userAccessor;
    private final SpaceAttributesManager spaceAttributesManager;
    private final LockpointGlobalSettingsManager globalSettingsManager;
    private final LockService lockService;
    private final LockHelper lockHelper;

    @Inject
    public LockpointSpaceRestResource(PermissionService permissionService, LockpointSpaceService lockpointSpaceService, @ComponentImport UserAccessor userAccessor, @ComponentImport I18nResolver i18nResolver, @ComponentImport FormatSettingsManager formatSettingsManager, @ComponentImport LocaleManager localeManager, LockpointConfluencePermissionService lockpointConfluencePermissionService, LockpointUtil lockpointUtil, SpaceAttributesManager spaceAttributesManager, LockpointGlobalSettingsManager lockpointGlobalSettingsManager, LockHelper lockHelper, LockService lockService) {
        super(lockpointUtil, lockpointSpaceService, i18nResolver, lockpointConfluencePermissionService);
        this.permissionService = permissionService;
        this.userAccessor = userAccessor;
        this.spaceAttributesManager = spaceAttributesManager;
        this.globalSettingsManager = lockpointGlobalSettingsManager;
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
        this.lockHelper = lockHelper;
        this.lockService = lockService;
    }

    @GET
    @Path(value="/{spaceKey}/permissions/user")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getUserPermissions(@PathParam(value="spaceKey") String object) {
        object = this.getUserPermissionsTransport((String)object);
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<Object>(object)).build();
    }

    private EntityPermissionTransport userKeyToEntityPermissionTransport(String string) {
        if ((string = this.userAccessor.getExistingUserByKey(new UserKey(string))) == null) {
            return null;
        }
        String string2 = this.userAccessor.getUserProfilePicture((User)string).getUriReference();
        return new EntityPermissionTransport(string.getName(), string.getFullName(), string2);
    }

    private List<EntityPermissionTransport> getUserPermissionsTransport(String object) {
        object = this.verifySpaceForReading((String)object);
        this.verifySpaceAdminPermissionsForReading((Space)object);
        object = this.permissionService.getPermissionsForSpace((Space)object, "user");
        return object.stream().map(this::userKeyToEntityPermissionTransport).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @PUT
    @Path(value="/{spaceKey}/permissions/user")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response putUserPermissions(@PathParam(value="spaceKey") String string, EntityPermissionTransport[] object) {
        Space space = this.verifySpaceForWriting(string);
        this.verifySpaceAdminPermissionsForWriting(space);
        object = Arrays.stream(object).filter(this::isValidUser).map(this::convertEntityPermissionToKeys).collect(Collectors.toList());
        this.permissionService.setPermissionsForSpace(space, "user", (List<String>)object);
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<List<EntityPermissionTransport>>(this.getUserPermissionsTransport(string), this.getI18nResolver().getText("com.arsenale.plugins.lockpoint.xwork.actions.EditSpaceConfigurationAction.usersupdated"))).build();
    }

    @GET
    @Path(value="/{spaceKey}/permissions/group")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getGroupPermissions(@PathParam(value="spaceKey") String object) {
        object = this.getGroupPermissionsTransport((String)object);
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<Object>(object)).build();
    }

    private EntityPermissionTransport groupNameToEntityPermissionTransport(String string) {
        if ((string = this.userAccessor.getGroup(string)) == null) {
            return null;
        }
        return new EntityPermissionTransport(string.getName(), string.getName(), null);
    }

    private List<EntityPermissionTransport> getGroupPermissionsTransport(String object) {
        object = this.verifySpaceForReading((String)object);
        this.verifySpaceAdminPermissionsForReading((Space)object);
        object = this.permissionService.getPermissionsForSpace((Space)object, "group");
        return object.stream().map(this::groupNameToEntityPermissionTransport).collect(Collectors.toList());
    }

    @PUT
    @Path(value="/{spaceKey}/permissions/group")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response putGroupPermissions(@PathParam(value="spaceKey") String string, EntityPermissionTransport[] object) {
        Space space = this.verifySpaceForWriting(string);
        this.verifySpaceAdminPermissionsForWriting(space);
        object = Arrays.stream(object).map(this::entityToString).filter(this::isValidGroup).collect(Collectors.toList());
        this.permissionService.setPermissionsForSpace(space, "group", (List<String>)object);
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<List<EntityPermissionTransport>>(this.getGroupPermissionsTransport(string), this.getI18nResolver().getText("com.arsenale.plugins.lockpoint.xwork.actions.EditSpaceConfigurationAction.groupsupdated"))).build();
    }

    @GET
    @Path(value="/{spaceKey}/active")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSpaceActivation(@PathParam(value="spaceKey") String object) {
        object = this.getSpaceActivationTransport((String)object);
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<Object>(object)).build();
    }

    private SpaceActivationTransport getSpaceActivationTransport(String string) {
        string = this.verifySpaceForReading(string);
        this.verifyLockpointAdminPermissionsForReading((Space)string);
        return new SpaceActivationTransport(this.spaceAttributesManager.getLockpointEnabled((Space)string), this.spaceAttributesManager.getDefaultLockpointEnabled(), this.spaceAttributesManager.isLockpointEnabledInSpace((Space)string), this.isLockpointAdmin((Space)string), this.isSpaceAdmin((Space)string));
    }

    @PUT
    @Path(value="/{spaceKey}/active")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response putSpaceActivation(@PathParam(value="spaceKey") String string, SpaceActivateTransport object) {
        Space space = this.verifySpaceForWriting(string);
        this.verifySpaceAdminPermissionsForWriting(space);
        this.spaceAttributesManager.setLockpointEnabled(space, ((SpaceActivateTransport)object).getActiveInSpace());
        object = this.getI18nResolver().getText("com.arsenale.plugins.lockpoint.xwork.actions.EditSpaceConfigurationAction.activationupdated");
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<SpaceActivationTransport>(this.getSpaceActivationTransport(string), (String)object)).build();
    }

    @GET
    @Path(value="/{spaceKey}/timeouts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSpaceTimeouts(@PathParam(value="spaceKey") String object) {
        object = this.verifySpaceForReading((String)object);
        this.verifySpaceAdminPermissionsForReading((Space)object);
        object = this.spaceAttributesManager.getTimeoutsForSpace((Space)object);
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<Object>(object)).build();
    }

    @PUT
    @Path(value="/{spaceKey}/timeouts")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setSpaceTimeouts(@PathParam(value="spaceKey") String object, SpaceTimeoutsTransport object2) {
        object = this.verifySpaceForWriting((String)object);
        this.verifySpaceAdminPermissionsForWriting((Space)object);
        this.spaceAttributesManager.setTimeoutsForSpace((Space)object, (SpaceTimeoutsTransport)object2);
        object2 = this.getI18nResolver().getText("com.arsenale.plugins.lockpoint.edittimeouts.timeoutsupdated");
        object = this.spaceAttributesManager.getTimeoutsForSpace((Space)object);
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<Object>(object, (String)object2)).build();
    }

    @GET
    @Path(value="/{spaceKey}/templates")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getSpaceTemplates(@PathParam(value="spaceKey") String object) {
        object = this.verifySpaceForReading((String)object);
        this.verifySpaceAdminPermissionsForReading((Space)object);
        object = this.spaceAttributesManager.getTemplatesForSpace((Space)object, AuthenticatedUserThreadLocal.get());
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<Object>(object)).build();
    }

    @PUT
    @Path(value="/{spaceKey}/templates")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setSpaceTemplates(@PathParam(value="spaceKey") String object, SpaceTemplatesTransport object2) {
        object = this.verifySpaceForWriting((String)object);
        this.verifySpaceAdminPermissionsForWriting((Space)object);
        this.spaceAttributesManager.setTemplatesForSpace((Space)object, (SpaceTemplatesTransport)object2);
        object2 = this.getI18nResolver().getText("com.arsenale.plugins.lockpoint.editemailtemplates.updated");
        object = this.spaceAttributesManager.getTemplatesForSpace((Space)object, AuthenticatedUserThreadLocal.get());
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<Object>(object, (String)object2)).build();
    }

    @GET
    @Path(value="/{spaceKey}/attachments/locked")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getLockedAttachments(@PathParam(value="spaceKey") String object) {
        object = this.getLockedAttachmentsTransport((String)object);
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload<Object>(object)).build();
    }

    private List<AttachmentTransport> getLockedAttachmentsTransport(String object) {
        object = this.verifySpaceForReading((String)object);
        this.verifyLockpointAdminPermissionsForReading((Space)object);
        if (!this.spaceAttributesManager.isLockpointEnabledInSpace((Space)object)) {
            return Collections.emptyList();
        }
        object = this.lockService.getLockedAttachmentsForSpace((Space)object);
        object.sort(z.a);
        return object.stream().map(this::lockToAttachmentTransport).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private AttachmentTransport lockToAttachmentTransport(o object) {
        if (object == null) {
            return null;
        }
        Attachment attachment = ((o)object).a();
        if (attachment == null) {
            return null;
        }
        ConfluenceUser confluenceUser = attachment.getCreator();
        ContentEntityObject contentEntityObject = attachment.getContainer();
        if (contentEntityObject == null) {
            return null;
        }
        ConfluenceUser confluenceUser2 = this.lockHelper.getLockOwnerUser((o)object);
        object = this.lockHelper.getLockDate((o)object);
        ConfluenceUserPreferences confluenceUserPreferences = this.userAccessor.getConfluenceUserPreferences((User)AuthenticatedUserThreadLocal.get());
        confluenceUserPreferences = confluenceUserPreferences.getTimeZone();
        confluenceUserPreferences = new DateFormatter((TimeZone)confluenceUserPreferences, this.formatSettingsManager, this.localeManager);
        return new AttachmentTransport(attachment.getId(), contentEntityObject.getId(), attachment.getFileName(), attachment.getFileSize(), attachment.getNiceFileSize(), confluenceUser != null ? confluenceUser.getFullName() : this.getI18nResolver().getText("anonymous.name"), confluenceUser != null ? confluenceUser.getName() : null, contentEntityObject.getTitle(), contentEntityObject.getUrlPath(), confluenceUser2 != null ? confluenceUser2.getName() : "", confluenceUser2 != null ? confluenceUser2.getFullName() : "", confluenceUserPreferences.formatDateTime((Date)object), (Date)object);
    }

    private boolean isValidUser(EntityPermissionTransport entityPermissionTransport) {
        return this.userAccessor.getUserByName(entityPermissionTransport.getName()) != null;
    }

    private String convertEntityPermissionToKeys(EntityPermissionTransport entityPermissionTransport) {
        return LockpointUtil.getStringKeyForUsername(entityPermissionTransport.getName());
    }

    private String entityToString(EntityPermissionTransport entityPermissionTransport) {
        return StringUtils.trim((String)entityPermissionTransport.getName());
    }

    private boolean isValidGroup(String string) {
        if (StringUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        return (string = this.userAccessor.getGroup(string)) != null;
    }
}

