/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.rest;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.cenotelabs.lockpoint.rest.SpaceAwareRestResource;
import com.cenotelabs.lockpoint.rest.transport.EntityPermissionTransport;
import com.cenotelabs.lockpoint.rest.transport.RestResultWithPayload;
import com.cenotelabs.lockpoint.services.LockpointConfluencePermissionService;
import com.cenotelabs.lockpoint.services.LockpointSpaceService;
import com.cenotelabs.lockpoint.util.LockpointUtil;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="/search")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class LockpointSearchRestResource
extends SpaceAwareRestResource {
    private static final int MAX_SEARCH_RESULTS = 100;
    private UserAccessor userAccessor;
    private CrowdService crowdService;

    @Inject
    public LockpointSearchRestResource(LockpointSpaceService lockpointSpaceService, @ComponentImport UserAccessor userAccessor, @ComponentImport I18nResolver i18nResolver, @ComponentImport CrowdService crowdService, LockpointConfluencePermissionService lockpointConfluencePermissionService, LockpointUtil lockpointUtil) {
        super(lockpointUtil, lockpointSpaceService, i18nResolver, lockpointConfluencePermissionService);
        this.crowdService = crowdService;
        this.userAccessor = userAccessor;
    }

    @GET
    @Path(value="/user")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response searchUsers(@QueryParam(value="search") String list, @QueryParam(value="spaceKey") String string) {
        string = this.verifySpaceForReading(string);
        this.verifyLockpointAdminPermissionsForReading((Space)string);
        if (StringUtils.isEmpty((CharSequence)((Object)list))) {
            list = null;
        }
        list = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)list)).startingAt(0).returningAtMost(100);
        list = this.crowdService.search((Query)list);
        list = StreamSupport.stream(list.spliterator(), false).map(user -> {
            ConfluenceUser confluenceUser = this.userAccessor.getUserByName(user.getName());
            return new EntityPermissionTransport(user.getName(), user.getDisplayName(), this.userAccessor.getUserProfilePicture((com.atlassian.user.User)confluenceUser).getUriReference());
        }).collect(Collectors.toList());
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload(list)).build();
    }

    @GET
    @Path(value="/group")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response searchGroups(@QueryParam(value="spaceKey") String list, @QueryParam(value="search") String string) {
        list = this.verifySpaceForReading((String)((Object)list));
        this.verifySpaceAdminPermissionsForReading((Space)list);
        list = NullRestrictionImpl.INSTANCE;
        if (!StringUtils.isEmpty((CharSequence)string)) {
            list = Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)GroupTermKeys.NAME).containing((Object)string), Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching((Object)Boolean.TRUE)});
        }
        list = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)list, 0, 100);
        list = this.crowdService.search((Query)list);
        list = StreamSupport.stream(list.spliterator(), false).map(Group::getName).collect(Collectors.toList());
        return Response.status((Response.Status)Response.Status.OK).entity(new RestResultWithPayload(list)).build();
    }
}

