/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.locks;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.cenotelabs.lockpoint.activeobjects.services.LockService;
import com.cenotelabs.lockpoint.licensing.LicenseManagerReason;
import com.cenotelabs.lockpoint.locks.LockAuditor;
import com.cenotelabs.lockpoint.locks.LockHelper;
import com.cenotelabs.lockpoint.locks.NotificationManager;
import com.cenotelabs.lockpoint.m;
import com.cenotelabs.lockpoint.o;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LockManager {
    private static final Logger a = LoggerFactory.getLogger(LockManager.class);
    private final I18nResolver b;
    private final LockService c;
    private final NotificationManager d;
    private final LockHelper e;
    private final LockAuditor f;

    @Inject
    public LockManager(I18nResolver i18nResolver, LockService lockService, NotificationManager notificationManager, LockHelper lockHelper, LockAuditor lockAuditor) {
        this.b = i18nResolver;
        this.c = lockService;
        this.d = notificationManager;
        this.e = lockHelper;
        this.f = lockAuditor;
    }

    public void lock(o o2, ConfluenceUser confluenceUser, boolean bl) {
        if (!this.e.isActiveInSpace(o2)) {
            return;
        }
        m m2 = this.e.getLicenseStatus();
        if (m2 != null && m2.a() != LicenseManagerReason.a) {
            a.error("Could not lock attachment due to licensing error: {}", (Object)this.b.getText(m2.b()));
            return;
        }
        this.f.logLockAction(o2, confluenceUser, "lock");
        this.c.lock(o2, confluenceUser, bl);
    }

    public void unlock(o o2, ConfluenceUser confluenceUser) {
        if (confluenceUser == null) {
            a.error("Anonymous user cannot unlock attachment {}", (Object)o2);
            return;
        }
        this.a(o2, confluenceUser);
    }

    public void unlockSystem(o o2) {
        this.a(o2, null);
    }

    private void a(o o2, ConfluenceUser confluenceUser) {
        if (!this.e.isActiveInSpace(o2)) {
            return;
        }
        this.f.logLockAction(o2, confluenceUser, "unlock");
        confluenceUser = o2.a();
        String string = o2.b().getNotifications();
        String string2 = this.e.getLockOwnerDisplayName(o2);
        Long l2 = o2.b().getLockedDate();
        this.c.unlock(o2);
        this.d.sendUnlockNotifications((Attachment)confluenceUser, string, l2, string2);
    }

    public void addNotification(o o2, ConfluenceUser object) {
        if (!this.e.isActiveInSpace(o2)) {
            return;
        }
        if (object == null) {
            a.warn("Cannot add notification for a null user");
            return;
        }
        object = object.getKey().getStringValue();
        this.c.addNotification(o2, (String)object);
    }

    public boolean notificationListContains(o o2, ConfluenceUser object) {
        if (!this.e.isActiveInSpace(o2)) {
            return false;
        }
        if (object == null) {
            return false;
        }
        object = object.getKey().getStringValue();
        return this.c.notificationListContains(o2, (String)object);
    }

    public void removeNotification(o o2, ConfluenceUser object) {
        if (!this.e.isActiveInSpace(o2)) {
            return;
        }
        if (object == null) {
            a.warn("Cannot remove notification for null user");
            return;
        }
        object = object.getKey().getStringValue();
        this.c.removeNotification(o2, (String)object);
    }
}

