/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.events;

import com.atlassian.confluence.event.events.admin.LicenceUpdatedEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.event.events.plugin.PluginDisableEvent;
import com.atlassian.confluence.event.events.plugin.PluginEnableEvent;
import com.atlassian.confluence.event.events.plugin.PluginInstallEvent;
import com.atlassian.confluence.event.events.plugin.PluginUninstallEvent;
import com.atlassian.event.Event;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.cenotelabs.lockpoint.events.LockpointLicenseEvent;
import com.cenotelabs.lockpoint.lifecycle.StartupAndShutdown;
import com.cenotelabs.lockpoint.xrefs.PluginXrefManager;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class AnnotationBasedEventListener
implements DisposableBean,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(AnnotationBasedEventListener.class);
    private final EventPublisher eventPublisher;
    private final StartupAndShutdown startupAndShutdown;
    private final PluginXrefManager pluginXrefManager;

    @Inject
    public AnnotationBasedEventListener(@ComponentImport EventPublisher eventPublisher, StartupAndShutdown startupAndShutdown, PluginXrefManager pluginXrefManager) {
        this.eventPublisher = eventPublisher;
        this.startupAndShutdown = startupAndShutdown;
        this.pluginXrefManager = pluginXrefManager;
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void handlePluginDisabling(PluginDisablingEvent pluginDisablingEvent) {
        this.logEvent(pluginDisablingEvent);
        if (pluginDisablingEvent.getPlugin().getKey().equals("com.arsenale.plugins.lockpoint")) {
            log.debug("Received PluginDisablingEvent - invoking disableLockpointFunctions");
            this.startupAndShutdown.b();
        }
    }

    @EventListener
    public void handleClusterEventWrapper(ClusterEventWrapper clusterEventWrapper) {
        this.logEvent(clusterEventWrapper);
        Event event = clusterEventWrapper.getEvent();
        log.debug("Received Cluster Event Wrapper: {} / {}", (Object)clusterEventWrapper, (Object)event);
        if (event instanceof LockpointLicenseEvent) {
            this.handleLockpointLicenseEvent((LockpointLicenseEvent)event);
        }
    }

    @EventListener
    public void handleLicenseUpdatedEvent(LicenceUpdatedEvent licenceUpdatedEvent) {
        this.logEvent(licenceUpdatedEvent);
        this.startupAndShutdown.d();
    }

    @EventListener
    public void handlePluginInstallEvent(PluginInstallEvent pluginInstallEvent) {
        this.logEvent(pluginInstallEvent);
        this.pluginXrefManager.receivedPluginEnabledEvent(pluginInstallEvent.getPluginKey());
    }

    @EventListener
    public void handlePluginEnableEvent(PluginEnableEvent pluginEnableEvent) {
        this.logEvent(pluginEnableEvent);
        this.pluginXrefManager.receivedPluginEnabledEvent(pluginEnableEvent.getPluginKey());
    }

    @EventListener
    public void handlePluginDisableEvent(PluginDisableEvent pluginDisableEvent) {
        this.logEvent(pluginDisableEvent);
        this.pluginXrefManager.receivedPluginDisabledEvent(pluginDisableEvent.getPluginKey());
    }

    @EventListener
    public void handlePluginUninstallEvent(PluginUninstallEvent pluginUninstallEvent) {
        this.logEvent(pluginUninstallEvent);
        this.pluginXrefManager.receivedPluginDisabledEvent(pluginUninstallEvent.getPluginKey());
    }

    @EventListener
    public void handleLockpointLicenseEvent(LockpointLicenseEvent lockpointLicenseEvent) {
        this.logEvent(lockpointLicenseEvent);
        this.startupAndShutdown.d();
    }

    private void logEvent(Object object) {
        log.debug("Received event: {}", object);
    }
}

