/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.locks;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.cenotelabs.lockpoint.api.LockpointGlobalSettingsManager;
import com.cenotelabs.lockpoint.licensing.LicenseManagerReason;
import com.cenotelabs.lockpoint.licensing.SimpleLicenseManager;
import com.cenotelabs.lockpoint.m;
import com.cenotelabs.lockpoint.o;
import com.cenotelabs.lockpoint.p;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import com.cenotelabs.lockpoint.util.DateHelper;
import com.cenotelabs.lockpoint.util.NullAcceptingDateFormat;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LockHelper {
    private static final Logger a = LoggerFactory.getLogger(LockHelper.class);
    private final SpaceAttributesManager b;
    private final UserAccessor c;
    private final LockpointGlobalSettingsManager d;
    private final I18nResolver e;
    private final SimpleLicenseManager f;
    private final DateHelper g;

    @Inject
    public LockHelper(SpaceAttributesManager spaceAttributesManager, UserAccessor userAccessor, LockpointGlobalSettingsManager lockpointGlobalSettingsManager, I18nResolver i18nResolver, SimpleLicenseManager simpleLicenseManager, DateHelper dateHelper) {
        this.b = spaceAttributesManager;
        this.c = userAccessor;
        this.d = lockpointGlobalSettingsManager;
        this.e = i18nResolver;
        this.f = simpleLicenseManager;
        this.g = dateHelper;
    }

    public boolean isActiveInSpace(o o2) {
        return (o2 = o2.e()) != null && this.b.isLockpointEnabledInSpace((Space)o2);
    }

    public boolean isLockedByAnyone(o o2) {
        return o2.h() && this.isActiveInSpace(o2);
    }

    public boolean isLockedWithWebDav(o o2) {
        return o2.h() && o2.b().isLockedWithWebDav() && this.isActiveInSpace(o2);
    }

    public String getLockOwner(o o2) {
        if (o2.h() && this.isActiveInSpace(o2)) {
            return o2.b().getOwner();
        }
        return null;
    }

    public ConfluenceUser getLockOwnerUser(o object) {
        if ((object = this.getLockOwner((o)object)) != null) {
            return this.c.getExistingUserByKey(new UserKey((String)object));
        }
        return null;
    }

    public String getLockOwnerDisplayName(o o2) {
        ConfluenceUser confluenceUser = this.getLockOwnerUser(o2);
        if (confluenceUser != null) {
            return confluenceUser.getFullName();
        }
        return this.getLockOwner(o2);
    }

    public boolean isLockedByCurrentUser(o o2) {
        return this.isLockedByGivenUser(o2, AuthenticatedUserThreadLocal.get());
    }

    public boolean isLockedByGivenUser(o object, ConfluenceUser object2) {
        if (object2 == null) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)(object2 = object2.getKey().getStringValue()))) {
            return false;
        }
        object = this.getLockOwner((o)object);
        return ((String)object2).equals(object);
    }

    public boolean isLockedByAnotherUser(o o2) {
        return this.isLockedByAnotherUser(o2, AuthenticatedUserThreadLocal.get());
    }

    public boolean isLockedByAnotherUser(o o2, ConfluenceUser confluenceUser) {
        boolean bl = this.isLockedByGivenUser(o2, confluenceUser);
        return !bl && this.isLockedByAnyone(o2);
    }

    public p isUploadAllowed(o object, ConfluenceUser object2, boolean bl) {
        if (!this.isActiveInSpace((o)object)) {
            return p.a;
        }
        Object object3 = this.getLicenseReason();
        if (object3 != LicenseManagerReason.a) {
            return p.a;
        }
        object3 = ((o)object).d();
        if (!this.isLockedByAnyone((o)object)) {
            if (bl || this.d.getPermitUploadWithoutLock()) {
                return p.a;
            }
            object2 = "com.arsenale.plugins.lockpoint.filemustbecheckedout";
            object = this.e.getText((String)object2, new Serializable[]{PlainTextToHtmlConverter.encodeHtmlEntities((String)object3)});
            String string = this.e.getText((String)object2, new Serializable[]{object3});
            return new p(false, (String)object, string);
        }
        if (!this.isLockedByGivenUser((o)object, (ConfluenceUser)object2)) {
            object2 = "com.arsenale.plugins.lockpoint.filecheckedouttootheruser";
            object = this.getLockOwnerDisplayName((o)object);
            String string = this.e.getText((String)object2, (Serializable[])PlainTextToHtmlConverter.encodeHtmlEntities((String[])new String[]{object3, object}));
            object = this.e.getText((String)object2, new Serializable[]{object3, object});
            return new p(false, string, (String)object);
        }
        return p.a;
    }

    public String renderLockWarningAsHtml(o o2) {
        try {
            String string = o2.d();
            String string2 = this.getUserDisplayStringForLock(o2);
            String string3 = this.getFormattedLockDate(o2);
            string2 = this.e.getText("com.arsenale.plugins.lockpoint.tooltip.lockedbysentence", new Serializable[]{string2, string3});
            return "<div class=\"arsenale-warning-nof\"><div class=\"lockpointicon lockedbysomeoneelse\">&nbsp;\n</div>\n<div class=\"lpinnerattach\">\n<span><strong>" + HtmlUtil.htmlEncode((String)string) + "</strong> \n" + string2 + "\n</span>\n</div>\n</div><br/>";
        }
        catch (Exception exception) {
            a.error("Could not render attachment warning for " + o2.a(), (Throwable)exception);
            return "*ERROR*";
        }
    }

    public String getLockedByOtherUserMessage(o o2) {
        return this.e.getText("com.arsenale.plugins.lockpoint.filecheckedouttootheruser", new Serializable[]{o2.d(), this.getLockOwnerDisplayName(o2)});
    }

    public LicenseManagerReason getLicenseReason() {
        return this.f.getLicenseReason(Locale.getDefault(), true);
    }

    public m getLicenseStatus() {
        return this.f.getLicenseStatus(Locale.getDefault(), true);
    }

    public Date getLockDate(o o2) {
        if (o2.b().isLocked()) {
            return new Date(o2.b().getLockedDate());
        }
        return null;
    }

    public String getFormattedLockDate(o object) {
        NullAcceptingDateFormat nullAcceptingDateFormat = this.g.getDateTimeFormatForUser(AuthenticatedUserThreadLocal.get());
        object = nullAcceptingDateFormat.format(this.getLockDate((o)object));
        if (object != null) {
            return object;
        }
        return "";
    }

    public String getUserDisplayStringForLock(o object) {
        if ((object = this.getLockOwnerUser((o)object)) == null) {
            return "";
        }
        String string = HtmlUtil.htmlEncode((String)object.getFullName());
        if (!StringUtils.isBlank((CharSequence)(object = object.getEmail()))) {
            return "<a href=\"mailto:" + HtmlUtil.htmlEncode((String)object) + "\">" + string + "</a>";
        }
        return string;
    }
}

