/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.sal.api.message.I18nResolver;
import com.cenotelabs.lockpoint.rest.RestUtil;
import com.cenotelabs.lockpoint.rest.transport.RestResult;
import com.cenotelabs.lockpoint.services.LockpointConfluencePermissionService;
import com.cenotelabs.lockpoint.services.LockpointSpaceService;
import com.cenotelabs.lockpoint.util.LockpointUtil;
import java.io.Serializable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public abstract class SpaceAwareRestResource {
    private final LockpointUtil lockpointUtil;
    private final LockpointSpaceService lockpointSpaceService;
    private final I18nResolver i18nResolver;
    private final LockpointConfluencePermissionService lockpointConfluencePermissionService;

    SpaceAwareRestResource(LockpointUtil lockpointUtil, LockpointSpaceService lockpointSpaceService, I18nResolver i18nResolver, LockpointConfluencePermissionService lockpointConfluencePermissionService) {
        this.lockpointUtil = lockpointUtil;
        this.lockpointSpaceService = lockpointSpaceService;
        this.i18nResolver = i18nResolver;
        this.lockpointConfluencePermissionService = lockpointConfluencePermissionService;
    }

    public I18nResolver getI18nResolver() {
        return this.i18nResolver;
    }

    private void verifyLockpointAdminPermissions(Space space, boolean bl) {
        if (!this.isLockpointAdmin(space)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new RestResult(RestUtil.getErrorTitle(this.i18nResolver, bl), this.i18nResolver.getText("com.arsenale.plugins.lockpoint.noPermissionForAction"))).build());
        }
    }

    void verifyLockpointAdminPermissionsForReading(Space space) {
        this.verifyLockpointAdminPermissions(space, false);
    }

    void verifyLockpointAdminPermissionsForWriting(Space space) {
        this.verifyLockpointAdminPermissions(space, true);
    }

    private void verifySpaceAdminPermissions(Space space, boolean bl) {
        if (!this.isSpaceAdmin(space)) {
            RestUtil.throwNoAccessError(this.i18nResolver, bl);
        }
    }

    void verifySpaceAdminPermissionsForReading(Space space) {
        this.verifySpaceAdminPermissions(space, false);
    }

    void verifySpaceAdminPermissionsForWriting(Space space) {
        this.verifySpaceAdminPermissions(space, true);
    }

    private Response badSpaceResponse(String string, boolean bl) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RestResult(RestUtil.getErrorTitle(this.i18nResolver, bl), this.i18nResolver.getText("com.arsenale.plugins.lockpoint.xwork.actions.EditSpaceConfigurationAction.spaceNotFound", new Serializable[]{string}))).build();
    }

    private Space verifySpace(String string, boolean bl) {
        Space space = this.lockpointSpaceService.getSpaceByKey(string);
        if (space == null) {
            throw new WebApplicationException(this.badSpaceResponse(string, bl));
        }
        return space;
    }

    Space verifySpaceForReading(String string) {
        return this.verifySpace(string, false);
    }

    Space verifySpaceForWriting(String string) {
        return this.verifySpace(string, true);
    }

    public boolean isLockpointAdmin(Space space) {
        return this.lockpointUtil.isLockpointAdministrator(AuthenticatedUserThreadLocal.get(), space);
    }

    public boolean isSpaceAdmin(Space space) {
        return this.lockpointConfluencePermissionService.hasPermission(AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, space);
    }

    public LockpointUtil getLockpointUtil() {
        return this.lockpointUtil;
    }
}

