/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.modules.servlets;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.cenotelabs.lockpoint.activeobjects.exceptions.LockpointAttachmentNotFoundException;
import com.cenotelabs.lockpoint.activeobjects.services.LockService;
import com.cenotelabs.lockpoint.locks.LockHelper;
import com.cenotelabs.lockpoint.o;
import com.cenotelabs.lockpoint.services.LockpointConfluencePermissionService;
import com.cenotelabs.lockpoint.services.LockpointContentService;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeEditServlet
extends HttpServlet {
    private static final Logger a = LoggerFactory.getLogger(SafeEditServlet.class);
    private final LockpointContentService lockpointContentService;
    private final LockpointConfluencePermissionService lockpointConfluencePermissionService;
    private final SpaceAttributesManager spaceAttributesManager;
    private final LockService lockService;
    private final LockHelper lockHelper;

    public SafeEditServlet(LockpointContentService lockpointContentService, LockpointConfluencePermissionService lockpointConfluencePermissionService, SpaceAttributesManager spaceAttributesManager, LockService lockService, LockHelper lockHelper) {
        this.lockpointContentService = lockpointContentService;
        this.lockpointConfluencePermissionService = lockpointConfluencePermissionService;
        this.spaceAttributesManager = spaceAttributesManager;
        this.lockService = lockService;
        this.lockHelper = lockHelper;
    }

    protected void doGet(HttpServletRequest object, HttpServletResponse httpServletResponse) {
        Object object2;
        Object object3;
        block11: {
            long l2;
            Object object4 = AuthenticatedUserThreadLocal.get();
            if (object4 == null) {
                httpServletResponse.setStatus(403);
                return;
            }
            object3 = object.getPathInfo();
            if (((String[])(object3 = StringUtils.split((String)object3, (char)'/'))).length < 3) {
                httpServletResponse.setStatus(404);
                return;
            }
            object2 = object.getQueryString();
            try {
                l2 = Long.parseLong(object3[0]);
            }
            catch (NumberFormatException numberFormatException) {
                httpServletResponse.setStatus(404);
                return;
            }
            AbstractPage abstractPage = this.lockpointContentService.getAbstractPageById(l2);
            if (abstractPage == null) {
                httpServletResponse.setStatus(404);
                return;
            }
            if (!this.lockpointConfluencePermissionService.hasPermission((ConfluenceUser)object4, Permission.VIEW, abstractPage)) {
                httpServletResponse.setStatus(403);
                return;
            }
            object4 = object3[1];
            Object[] objectArray = new String[((String[])object3).length - 2];
            System.arraycopy(object3, 2, objectArray, 0, ((String[])object3).length - 2);
            object3 = "/" + StringUtils.join((Object[])objectArray, (String)"/");
            if (object2 != null) {
                object3 = (String)object3 + "?" + (String)object2;
            }
            try {
                object2 = this.lockService.getLock((ContentEntityObject)abstractPage, (String)object4);
                if (!this.spaceAttributesManager.isLockpointEnabledInSpace(((o)object2).a().getSpace()) || this.lockHelper.isLockedByCurrentUser((o)object2)) break block11;
                a.debug("The attachment {} on page {} was no longer locked by the current user.", object4, (Object)l2);
                try {
                    object2 = URLEncoder.encode((String)object4, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object2 = object4;
                }
                object3 = "/lockpoint/notlocked.action?pageId=" + l2 + "&fileName=" + (String)object2;
            }
            catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {}
        }
        object2 = object.getContextPath() + (String)object3;
        object = httpServletResponse.encodeRedirectURL((String)object2);
        a.debug("Forwarding request to {}; encoded as: {}", object2, object);
        httpServletResponse.sendRedirect((String)object);
    }
}

