/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.mail;

import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.mail.template.AbstractMailNotificationQueueItem;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.ConfluenceRenderUtils;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.mail.Email;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.atlassian.velocity.VelocityContextUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailQueueItemFromContent
extends AbstractMailNotificationQueueItem
implements MailQueueItem {
    private static final Logger log = LoggerFactory.getLogger(MailQueueItemFromContent.class);
    private String renderedSubject;
    private String email;
    private Map<String, Object> context = new HashMap<String, Object>();

    public MailQueueItemFromContent(User user, String string, String string2) {
        super(string);
        this.setSubject(string2);
        this.email = user.getEmail();
    }

    public MailQueueItemFromContent(String string, String string2, String string3) {
        super(string2);
        this.setSubject(string3);
        this.email = string;
    }

    private Map<String, Object> getLockpointInitialContext() {
        Map map = MacroUtils.defaultVelocityContext();
        Object object = (ContextPathHolder)ContainerManager.getComponent((String)"contextPathHolder");
        if (StringUtils.isNotEmpty((CharSequence)(object = object.getContextPath())) && !((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        map.put("contextPath", object);
        map.put("stylesheet", ConfluenceRenderUtils.renderDefaultStylesheet());
        map.put("resourceBundle", GeneralUtil.getI18n().getResourceBundle());
        map.putAll(this.context);
        return map;
    }

    public void addVelocityContextParam(String string, Object object) {
        super.addVelocityContextParam(string, object);
        this.context.put(string, object);
    }

    public Object removeVelocityContextParam(String string) {
        super.removeVelocityContextParam(string);
        return this.context.remove(string);
    }

    public void clearContext() {
        super.clearContext();
        this.context.clear();
    }

    public Object getVelocityContextParam(String string) {
        super.getVelocityContextParam(string);
        return this.context.get(string);
    }

    private String getLockpointRenderedContent(String string) {
        Map map = VelocityContextUtils.getContextParamsBody(this.getLockpointInitialContext());
        if (string == null) {
            return null;
        }
        for (Map.Entry entry : map.entrySet()) {
            String string2 = entry.getValue() != null ? entry.getValue().toString() : "";
            string = string.replaceAll(Pattern.quote("$" + (String)entry.getKey()), Matcher.quoteReplacement(string2));
        }
        return string;
    }

    public void render() {
        this.renderedSubject = this.getLockpointRenderedContent(this.getSubject());
        this.addVelocityContextParam("subject", this.renderedSubject);
        this.body = this.getLockpointRenderedContent(this.getTemplateContent());
        this.clearContext();
    }

    protected Email createMailObject() {
        Email email = new Email(this.email);
        email.setEncoding("UTF-8");
        email.setSubject(this.renderedSubject);
        email.setBody(this.body);
        email.setMimeType("text/plain");
        this.setLastError(null);
        return email;
    }

    protected String getMimeType() {
        return "text/plain";
    }
}

