/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.lifecycle;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.cenotelabs.lockpoint.framework.FrameworkManager;
import com.cenotelabs.lockpoint.licensing.LicenseManagerReason;
import com.cenotelabs.lockpoint.licensing.SimpleLicenseManager;
import com.cenotelabs.lockpoint.lifecycle.PluginState;
import com.cenotelabs.lockpoint.m;
import com.cenotelabs.lockpoint.n;
import com.cenotelabs.lockpoint.velocity.srl.StringResourceLoaderInstaller;
import com.cenotelabs.lockpoint.xrefs.PluginLinksManager;
import com.cenotelabs.lockpoint.xrefs.PluginXrefManager;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class StartupAndShutdown
implements InitializingBean {
    private static final Logger a = LoggerFactory.getLogger(StartupAndShutdown.class);
    private final PluginXrefManager b;
    private final PluginLinksManager c;
    private volatile boolean d = false;
    private final SimpleLicenseManager e;
    private Boolean f = Boolean.FALSE;
    private final ApplicationProperties g;
    private final WebInterfaceManager h;
    private final PluginAccessor i;
    private final StringResourceLoaderInstaller j;
    private final FrameworkManager k;
    private final PluginState l;
    private final I18nResolver m;
    private static int n = 0;
    private volatile boolean o = false;
    private volatile boolean p = false;
    private final Object q = new Object();
    private final Object r = new Object();
    private final Lock s;

    @Inject
    public StartupAndShutdown(SimpleLicenseManager simpleLicenseManager, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport ApplicationProperties applicationProperties, PluginXrefManager pluginXrefManager, PluginLinksManager pluginLinksManager, @ComponentImport WebInterfaceManager webInterfaceManager, PluginState pluginState, StringResourceLoaderInstaller stringResourceLoaderInstaller, FrameworkManager frameworkManager, @ComponentImport I18nResolver i18nResolver) {
        this.e = simpleLicenseManager;
        this.i = pluginAccessor;
        this.g = applicationProperties;
        this.b = pluginXrefManager;
        this.c = pluginLinksManager;
        this.h = webInterfaceManager;
        this.j = stringResourceLoaderInstaller;
        this.l = pluginState;
        this.k = frameworkManager;
        this.m = i18nResolver;
        this.s = new ReentrantLock();
    }

    public void afterPropertiesSet() {
        n = Integer.parseInt(this.g.getBuildNumber());
        this.d = true;
        a.debug("Cenote Lockpoint v{} starting with Confluence build {}", (Object)com.cenotelabs.lockpoint.n.a(), (Object)n);
    }

    public final boolean a() {
        a.debug("Public finalInit");
        Object object = this.q;
        synchronized (object) {
            if (!this.d) {
                a.debug("Deferring finalInit because afterPropertiesSet not executed");
                return true;
            }
            if (this.o) {
                a.debug("Not performing finalInit because somebody else is!");
                return false;
            }
            if (!this.j.isVelocityLoaded()) {
                a.debug("Not performing finalInit because Velocity is not yet loaded");
                return true;
            }
            this.o = true;
        }
        try {
            this.s.lock();
            boolean bl = this.e();
            return bl;
        }
        finally {
            this.s.unlock();
            this.o = false;
            a.debug("Finished finalInit");
        }
    }

    private boolean e() {
        boolean bl = this.i.isPluginEnabled("com.arsenale.plugins.lockpoint");
        a.debug("Attempting FI - FIP={}", (Object)this.l.a());
        if (!bl) {
            a.debug("Lockpoint was not enabled when finalInit was called, so deferring");
            return true;
        }
        if (this.l.a()) {
            return false;
        }
        a.debug("Performing FI");
        m m2 = this.i();
        if (m2.a() != LicenseManagerReason.a) {
            a.debug("License is invalid, so Lockpoint will not be enabled");
            if (!this.f.booleanValue()) {
                this.f = Boolean.TRUE;
                a.error("License status: {}", (Object)this.m.getText(m2.b()));
                a.error("The license check failed and Lockpoint cannot operate until a valid license is installed");
            }
            this.h();
            return false;
        }
        this.k.startup();
        this.b.startup();
        this.g();
        this.h.refresh();
        this.l.a(true);
        a.debug("FI finished");
        return false;
    }

    public final void b() {
        a.debug("Disabling Lockpoint functions");
        Object object = this.r;
        synchronized (object) {
            if (this.p) {
                a.debug("Not performing disableLockpointFunctions because somebody else is!");
                return;
            }
            this.p = true;
        }
        this.s.lock();
        try {
            this.f();
            return;
        }
        finally {
            this.s.unlock();
            this.p = false;
        }
    }

    private void f() {
        try {
            a.debug("Lockpoint shutting down - FI={}", (Object)this.l.a());
            if (this.l.a()) {
                this.l.a(false);
                this.h();
                this.b.shutdown();
                this.k.shutdown();
            }
            a.debug("Internal shutdown complete");
            return;
        }
        catch (Exception exception) {
            a.error("Got error during destroy", (Throwable)exception);
            return;
        }
    }

    private void g() {
        this.c.hidePluginLink("confluence.sections.attachments:edit");
        this.c.hidePluginLink("confluence.sections.attachments:remove");
        this.c.hidePluginLink("confluence.sections.attachments:remove-version");
        a.debug("A disabled");
    }

    private void h() {
        a.debug("A reenabled");
        this.c.reenablePluginLink("confluence.sections.attachments:edit");
        this.c.reenablePluginLink("confluence.sections.attachments:remove");
        this.c.reenablePluginLink("confluence.sections.attachments:remove-version");
    }

    public static int c() {
        return n;
    }

    private m i() {
        return this.e.getLicenseStatus(Locale.getDefault(), true);
    }

    public final void d() {
        a.debug("Updating Lockpoint after change to plugin or system license");
        this.l.b(true);
        LicenseManagerReason licenseManagerReason = this.e.systemLicenseUpdated();
        if (licenseManagerReason == LicenseManagerReason.a) {
            this.a();
            return;
        }
        a.warn("Standing down due to licensing issue");
        if (this.l.a()) {
            try {
                this.b();
                return;
            }
            catch (Exception exception) {
                a.error("Error disabling plugin", (Throwable)exception);
            }
        }
    }
}

