/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.i18n;

import com.atlassian.confluence.languages.LanguageManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.cenotelabs.lockpoint.rest.transport.LanguageTransport;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class LanguageHelper {
    private LanguageManager a;
    private LocaleManager b;

    @Inject
    public LanguageHelper(@ComponentImport LanguageManager languageManager, @ComponentImport LocaleManager localeManager) {
        this.a = languageManager;
        this.b = localeManager;
    }

    public List<LanguageTransport> getSupportedLanguages() {
        List list = this.a.getLanguages();
        return list.stream().map(language -> new LanguageTransport(language.getLocale().toLanguageTag(), language.getDisplayName())).collect(Collectors.toList());
    }

    public List<String> getSupportedLanguageKeys() {
        return this.getSupportedLanguages().stream().map(LanguageTransport::getIso).collect(Collectors.toList());
    }

    public String getLanguageTagForUser(ConfluenceUser confluenceUser) {
        return this.b.getLocale((User)confluenceUser).toLanguageTag();
    }
}

