/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.mail;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.cenotelabs.lockpoint.mail.MailQueueItemFromContent;
import com.cenotelabs.lockpoint.util.NullAcceptingDateFormat;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MailHelper {
    private static final Logger log = LoggerFactory.getLogger(MailHelper.class);
    private ApplicationProperties applicationProperties;
    private MultiQueueTaskManager taskManager;

    @Inject
    public MailHelper(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport MultiQueueTaskManager multiQueueTaskManager) {
        this.applicationProperties = applicationProperties;
        this.taskManager = multiQueueTaskManager;
    }

    public void addAttachmentBaseVelocityContext(MailQueueItemFromContent mailQueueItemFromContent, Attachment attachment, Long l2, NullAcceptingDateFormat nullAcceptingDateFormat, String string) {
        String string2 = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        ContentEntityObject contentEntityObject = attachment.getContainer();
        string2 = contentEntityObject != null ? string2 + contentEntityObject.getUrlPath() : null;
        mailQueueItemFromContent.addVelocityContextParam("attachmentName", attachment.getFileName());
        mailQueueItemFromContent.addVelocityContextParam("pageName", contentEntityObject != null ? contentEntityObject.getTitle() : null);
        mailQueueItemFromContent.addVelocityContextParam("pageLink", string2);
        mailQueueItemFromContent.addVelocityContextParam("lockedDate", nullAcceptingDateFormat.format(l2));
        mailQueueItemFromContent.addVelocityContextParam("owner", string);
    }

    public void sendEmail(MailQueueItemFromContent mailQueueItemFromContent) {
        Map map = RequestCacheThreadLocal.getRequestCache();
        if (RequestCacheThreadLocal.getContextPath() == null) {
            log.debug("Inserting empty context path to work around ConfluenceWebResourceIntegration issue!");
            map.put("confluence.context.path", "");
            RequestCacheThreadLocal.setRequestCache((Map)map);
        }
        mailQueueItemFromContent.render();
        this.taskManager.addTask("mail", (Task)mailQueueItemFromContent);
    }
}

