/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.locks;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.cenotelabs.lockpoint.activeobjects.models.Template;
import com.cenotelabs.lockpoint.activeobjects.services.LockService;
import com.cenotelabs.lockpoint.mail.MailHelper;
import com.cenotelabs.lockpoint.mail.MailQueueItemFromContent;
import com.cenotelabs.lockpoint.model.EmailTemplate;
import com.cenotelabs.lockpoint.services.LockpointDisabledUserService;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import com.cenotelabs.lockpoint.util.DateHelper;
import com.cenotelabs.lockpoint.util.NullAcceptingDateFormat;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NotificationManager {
    private static final Logger a = LoggerFactory.getLogger(NotificationManager.class);
    private final SpaceAttributesManager b;
    private final UserAccessor c;
    private final DateHelper d;
    private final MailHelper e;
    private final LockpointDisabledUserService f;

    @Inject
    public NotificationManager(SpaceAttributesManager spaceAttributesManager, UserAccessor userAccessor, DateHelper dateHelper, MailHelper mailHelper, LockpointDisabledUserService lockpointDisabledUserService) {
        this.b = spaceAttributesManager;
        this.c = userAccessor;
        this.d = dateHelper;
        this.e = mailHelper;
        this.f = lockpointDisabledUserService;
    }

    public void sendUnlockNotifications(Attachment attachment, String stringArray, Long l2, String string) {
        if (stringArray == null) {
            return;
        }
        long l3 = attachment.getId();
        String[] stringArray2 = stringArray.split(LockService.a);
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ConfluenceUser confluenceUser;
            Object object = stringArray[i2];
            try {
                confluenceUser = this.c.getExistingUserByKey(new UserKey((String)object));
            }
            catch (Exception exception) {
                confluenceUser = null;
            }
            if (confluenceUser == null) {
                a.warn("Could not find user object to send notification for userkey {} for locked attachment {}", object, (Object)l3);
                continue;
            }
            if (this.f.isDisabled((User)confluenceUser)) {
                a.warn("Not sending notification to disabled user {} for locked attachment {}", object, (Object)l3);
                continue;
            }
            object = confluenceUser.getName();
            a.debug("Sending unlock notification to {} for attachment {}", object, (Object)l3);
            Object object2 = confluenceUser.getEmail();
            if (StringUtils.isBlank((CharSequence)object2)) {
                a.warn("Could not send Cenote Lockpoint notification to user {} because the user's email address was empty.", object);
                return;
            }
            object = attachment.getSpace();
            object2 = this.d.getDateTimeFormatForUser(confluenceUser);
            object = this.b.getTemplateForSpace((Space)object, Template.Type.NOTIFY, confluenceUser);
            object = new MailQueueItemFromContent((User)confluenceUser, ((EmailTemplate)object).getBody(), ((EmailTemplate)object).getSubject());
            this.e.addAttachmentBaseVelocityContext((MailQueueItemFromContent)((Object)object), attachment, l2, (NullAcceptingDateFormat)object2, string);
            this.e.sendEmail((MailQueueItemFromContent)((Object)object));
        }
    }
}

