/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.util;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.atlassian.xwork.XsrfTokenGenerator;
import com.cenotelabs.lockpoint.activeobjects.services.PermissionService;
import com.cenotelabs.lockpoint.lifecycle.PluginState;
import com.cenotelabs.lockpoint.r;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LockpointUtil {
    private static UserAccessor a;
    private final PermissionManager b;
    private final UserAccessor c;
    private final SpaceAttributesManager d;
    private final PermissionService e;
    private final PluginState f;

    @Inject
    public LockpointUtil(@ComponentImport PermissionManager permissionManager, @ComponentImport UserAccessor userAccessor, SpaceAttributesManager spaceAttributesManager, PermissionService permissionService, PluginState pluginState) {
        this.b = permissionManager;
        this.c = userAccessor;
        this.d = spaceAttributesManager;
        this.e = permissionService;
        this.f = pluginState;
    }

    public boolean isLockpointAdministrator(ConfluenceUser object, Space object2) {
        String string;
        if (this.b.isConfluenceAdministrator((User)object) || this.b.isSystemAdministrator((User)object)) {
            return true;
        }
        if (this.b.hasPermission((User)object, Permission.ADMINISTER, object2)) {
            return true;
        }
        if (object == null) {
            return false;
        }
        List<String> list = this.e.getPermissionsForSpace((Space)object2, "user");
        if (list.contains(string = object.getKey().getStringValue())) {
            return true;
        }
        if ((object2 = this.e.getPermissionsForSpace((Space)object2, "group")).size() != 0) {
            object = this.c.getGroupNames((User)object);
            object = new HashSet(object);
            object2 = new HashSet(object2);
            object2.retainAll((Collection<?>)object);
            return object2.size() > 0;
        }
        return false;
    }

    public static String generateCheckInOutURL(Boolean bl, HttpServletRequest httpServletRequest, r r2, ContentEntityObject contentEntityObject, XsrfTokenGenerator xsrfTokenGenerator, Boolean bl2) {
        try {
            String string = httpServletRequest.getContextPath();
            string = bl != false ? string + "/lockpoint/unlock.action" : string + "/lockpoint/lock.action";
            string = string + "?fileName=" + URLEncoder.encode(r2.d(), "UTF-8") + "&pageId=" + r2.g() + "&onSuccess=" + URLEncoder.encode(contentEntityObject.getUrlPath(), "UTF-8") + "&" + xsrfTokenGenerator.getXsrfTokenName() + "=" + xsrfTokenGenerator.generateToken(httpServletRequest);
            if (bl2.booleanValue()) {
                string = string + "&forced=true";
            }
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public Boolean hasPermissionToLockUnlockAll(ConfluenceUser confluenceUser, ContentEntityObject contentEntityObject) {
        return confluenceUser != null && this.d.isLockpointEnabledInSpace(contentEntityObject) && this.f.a() && this.b.hasCreatePermission((User)confluenceUser, (Object)contentEntityObject, Attachment.class);
    }

    private static UserAccessor a() {
        if (a != null) {
            return a;
        }
        a = (UserAccessor)ContainerManager.getComponent((String)"userAccessor", UserAccessor.class);
        return a;
    }

    public static String getStringKeyForUsername(String string) {
        string = LockpointUtil.a().getUserByName(string);
        if (string == null) {
            return null;
        }
        if ((string = string.getKey()) != null) {
            return string.getStringValue();
        }
        return null;
    }

    static {
        LoggerFactory.getLogger(LockpointUtil.class);
    }
}

