/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.locks;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.message.I18nResolver;
import com.cenotelabs.lockpoint.activeobjects.services.LockService;
import com.cenotelabs.lockpoint.licensing.LicenseManagerReason;
import com.cenotelabs.lockpoint.locks.LockAuditor;
import com.cenotelabs.lockpoint.locks.LockHelper;
import com.cenotelabs.lockpoint.locks.NotificationManager;
import com.cenotelabs.lockpoint.p;
import com.cenotelabs.lockpoint.r;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LockManager {
    private static final Logger a = LoggerFactory.getLogger(LockManager.class);
    private final I18nResolver b;
    private final LockService c;
    private final NotificationManager d;
    private final LockHelper e;
    private final LockAuditor f;

    @Inject
    public LockManager(I18nResolver i18nResolver, LockService lockService, NotificationManager notificationManager, LockHelper lockHelper, LockAuditor lockAuditor) {
        this.b = i18nResolver;
        this.c = lockService;
        this.d = notificationManager;
        this.e = lockHelper;
        this.f = lockAuditor;
    }

    public void lock(r r2, ConfluenceUser confluenceUser, boolean bl) {
        if (!this.e.isActiveInSpace(r2)) {
            return;
        }
        p p2 = this.e.getLicenseStatus();
        if (p2 != null && p2.a() != LicenseManagerReason.a) {
            a.error("Could not lock attachment due to licensing error: {}", (Object)this.b.getText(p2.b(), p2.c()));
            return;
        }
        this.f.logLockAction(r2, confluenceUser, "lock");
        this.c.lock(r2, confluenceUser, bl);
    }

    public void unlock(r r2, ConfluenceUser confluenceUser) {
        if (confluenceUser == null) {
            a.error("Anonymous user cannot unlock attachment {}", (Object)r2);
            return;
        }
        this.a(r2, confluenceUser);
    }

    public void unlockSystem(r r2) {
        this.a(r2, null);
    }

    private void a(r r2, ConfluenceUser confluenceUser) {
        if (!this.e.isActiveInSpace(r2)) {
            return;
        }
        this.f.logLockAction(r2, confluenceUser, "unlock");
        confluenceUser = r2.a();
        String string = r2.b().getNotifications();
        String string2 = this.e.getLockOwnerDisplayName(r2);
        Long l2 = r2.b().getLockedDate();
        this.c.unlock(r2);
        this.d.sendUnlockNotifications((Attachment)confluenceUser, string, l2, string2);
    }

    public void addNotification(r r2, ConfluenceUser object) {
        if (!this.e.isActiveInSpace(r2)) {
            return;
        }
        if (object == null) {
            a.warn("Cannot add notification for a null user");
            return;
        }
        object = object.getKey().getStringValue();
        this.c.addNotification(r2, (String)object);
    }

    public boolean notificationListContains(r r2, ConfluenceUser object) {
        if (!this.e.isActiveInSpace(r2)) {
            return false;
        }
        if (object == null) {
            return false;
        }
        object = object.getKey().getStringValue();
        return this.c.notificationListContains(r2, (String)object);
    }

    public void removeNotification(r r2, ConfluenceUser object) {
        if (!this.e.isActiveInSpace(r2)) {
            return;
        }
        if (object == null) {
            a.warn("Cannot remove notification for null user");
            return;
        }
        object = object.getKey().getStringValue();
        this.c.removeNotification(r2, (String)object);
    }
}

