/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.struts.interceptors;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.actions.RemoveAttachedFileVersionAction;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.spring.container.ContainerManager;
import com.cenotelabs.lockpoint.B;
import com.cenotelabs.lockpoint.activeobjects.exceptions.LockpointAttachmentNotFoundException;
import com.cenotelabs.lockpoint.activeobjects.services.LockService;
import com.cenotelabs.lockpoint.framework.LockpointServletActionContext;
import com.cenotelabs.lockpoint.lifecycle.PluginState;
import com.cenotelabs.lockpoint.locks.LockHelper;
import com.cenotelabs.lockpoint.locks.LockManager;
import com.cenotelabs.lockpoint.r;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import org.apache.struts2.dispatcher.HttpParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StrutsRemoveAttachmentVersionInterceptor
extends B
implements Interceptor {
    private static final Logger a = LoggerFactory.getLogger(StrutsRemoveAttachmentVersionInterceptor.class);
    private final LockpointServletActionContext lockpointServletActionContext;
    private final SpaceAttributesManager spaceAttributesManager;
    private final LockService lockService;
    private final LockHelper lockHelper;
    private final LockManager lockManager;
    private final PluginState pluginState;

    public StrutsRemoveAttachmentVersionInterceptor(AttachmentManager attachmentManager, PageManager pageManager, SpaceAttributesManager spaceAttributesManager, LockpointServletActionContext lockpointServletActionContext, LockService lockService, LockHelper lockHelper, LockManager lockManager, PluginState pluginState) {
        super(attachmentManager, pageManager);
        this.spaceAttributesManager = spaceAttributesManager;
        this.lockpointServletActionContext = lockpointServletActionContext;
        this.lockService = lockService;
        this.lockHelper = lockHelper;
        this.lockManager = lockManager;
        this.pluginState = pluginState;
    }

    public String intercept(ActionInvocation object) {
        if (!this.pluginState.a()) {
            return object.invoke();
        }
        Object object2 = (HttpParameters)object.getInvocationContext().getContextMap().get("parameters");
        String string = this.a((HttpParameters)object2);
        AbstractPage abstractPage = this.c((HttpParameters)object2);
        object2 = this.b((HttpParameters)object2);
        Attachment attachment = this.a(abstractPage, string, (Integer)object2);
        a.debug("Ready to remove attachment {} version {} from page {}", new Object[]{attachment, object2, abstractPage});
        r r2 = null;
        if (object.getAction() instanceof RemoveAttachedFileVersionAction && attachment != null && abstractPage != null && object2 != null && this.spaceAttributesManager.isLockpointEnabledInSpace(attachment.getSpace())) {
            try {
                r2 = this.lockService.getLock(attachment);
            }
            catch (LockpointAttachmentNotFoundException lockpointAttachmentNotFoundException) {
                this.lockpointServletActionContext.getResponse().setStatus(403);
                return "error";
            }
            a.debug("Testing attachment {} to see if we can delete a version", (Object)r2);
            if (this.lockHelper.isLockedByAnyone(r2) && !this.lockHelper.isLockedByCurrentUser(r2)) {
                object = (RemoveAttachedFileVersionAction)object.getAction();
                object2 = (I18NBean)ContainerManager.getComponent((String)"i18NBean");
                object.addActionError(object2.getText("com.arsenale.plugins.lockpoint.filecheckedouttootheruser", (Object[])PlainTextToHtmlConverter.encodeHtmlEntities((String[])new String[]{attachment.getFileName(), this.lockHelper.getLockOwnerDisplayName(r2)})));
                this.lockpointServletActionContext.getResponse().setStatus(403);
                return "error";
            }
        }
        if ((object = object.invoke()).equals("success") && (attachment = this.a(abstractPage, string, null)) == null && r2 != null) {
            a.debug("Removing Lockpoint data for {}", (Object)r2);
            this.lockManager.unlock(r2, AuthenticatedUserThreadLocal.get());
        }
        return object;
    }
}

