/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.activeobjects.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.cenotelabs.lockpoint.activeobjects.daos.TemplateDao;
import com.cenotelabs.lockpoint.activeobjects.models.CustomizableTemplate;
import com.cenotelabs.lockpoint.activeobjects.models.Template;
import java.util.Locale;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TemplateService {
    private static final Logger a = LoggerFactory.getLogger(TemplateService.class);
    private ActiveObjects b;
    private TemplateDao c;
    private I18nResolver d;

    @Inject
    public TemplateService(ActiveObjects activeObjects, TemplateDao templateDao, @ComponentImport I18nResolver i18nResolver) {
        this.b = activeObjects;
        this.c = templateDao;
        this.d = i18nResolver;
    }

    public Template get(Space space, Template.Type type, String string) {
        return this.c.get(this.b, space, type, string);
    }

    public CustomizableTemplate getDefault(Template.Type type, String string) {
        boolean bl = true;
        Template template = this.get(null, type, string);
        if (template == null) {
            template = this.getLanguageFileTemplate(type, string);
            bl = false;
        }
        return new CustomizableTemplate(template, bl);
    }

    public Template getLanguageFileTemplate(Template.Type type, String string) {
        Locale locale;
        try {
            locale = Locale.forLanguageTag(string);
        }
        catch (Throwable throwable) {
            locale = Locale.getDefault();
            a.error("Could not parse language tag for {}; using default locale {}.", (Object)string, (Object)locale.toLanguageTag());
            string = locale.toLanguageTag();
        }
        try {
            return this.a(locale, string, type);
        }
        catch (Throwable throwable) {
            a.error("Could not fetch language file template for locale " + locale.toLanguageTag() + "; using default English template.", throwable);
            Locale locale2 = Locale.US;
            return this.a(locale2, locale2.toLanguageTag(), type);
        }
    }

    private Template a(Locale object, String string, Template.Type type) {
        String string2;
        switch (type) {
            case WARNING: {
                string2 = this.d.getText((Locale)object, "com.arsenale.plugins.lockpoint.defaultWarningTemplateSubject");
                object = this.d.getText((Locale)object, "com.arsenale.plugins.lockpoint.defaultWarningTemplateBody");
                break;
            }
            case UNLOCK: {
                string2 = this.d.getText((Locale)object, "com.arsenale.plugins.lockpoint.defaultForcedCheckinTemplateSubject");
                object = this.d.getText((Locale)object, "com.arsenale.plugins.lockpoint.defaultForcedCheckinTemplateBody");
                break;
            }
            case NOTIFY: {
                string2 = this.d.getText((Locale)object, "com.arsenale.plugins.lockpoint.notificationemailsubject");
                object = this.d.getText((Locale)object, "com.arsenale.plugins.lockpoint.notificationemailbody");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected template type: " + (Object)((Object)type));
            }
        }
        return new Template(null, Template.Format.TEXT, type, string, string2, (String)object);
    }

    public void set(Template template) {
        this.c.save(this.b, template);
    }

    public void remove(Space space, Template.Type type, String string) {
        this.c.delete(this.b, space, type, string);
    }
}

