/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.activeobjects;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.cenotelabs.lockpoint.activeobjects.AoUpgradeAsyncTask1;
import com.cenotelabs.lockpoint.activeobjects.daos.AttributeDao;
import com.cenotelabs.lockpoint.activeobjects.daos.TemplateDao;
import com.cenotelabs.lockpoint.activeobjects.entities.AttrEntity;
import com.cenotelabs.lockpoint.activeobjects.entities.TemplateEntity;
import com.cenotelabs.lockpoint.background.BackgroundActionQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AoUpgradeTask1
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(AoUpgradeTask1.class);
    public static final ModelVersion NOT_INSTALLED = ModelVersion.valueOf((String)"0");
    public static final ModelVersion CURRENT_VERSION = ModelVersion.valueOf((String)"1");
    private TemplateDao templateDao;
    private AttributeDao attributeDao;
    private BackgroundActionQueue backgroundActionQueue;
    private AoUpgradeAsyncTask1 upgradeTaskAsync;

    public AoUpgradeTask1(TemplateDao templateDao, AttributeDao attributeDao, BackgroundActionQueue backgroundActionQueue, AoUpgradeAsyncTask1 aoUpgradeAsyncTask1) {
        this.templateDao = templateDao;
        this.attributeDao = attributeDao;
        this.backgroundActionQueue = backgroundActionQueue;
        this.upgradeTaskAsync = aoUpgradeAsyncTask1;
    }

    public ModelVersion getModelVersion() {
        return CURRENT_VERSION;
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        try {
            if (modelVersion.isSame(NOT_INSTALLED)) {
                this.convertFromBandana(activeObjects);
            }
            return;
        }
        catch (Throwable throwable) {
            log.error("Could not perform ActiveObjects upgrade", throwable);
            return;
        }
    }

    private void convertFromBandana(ActiveObjects activeObjects) {
        log.info("Begin Bandana to ActiveObjects upgradeTask 1");
        activeObjects.migrate(new Class[]{AttrEntity.class, TemplateEntity.class});
        log.info("Task 1 entities created; queueing background thread to perform upgrade");
        this.backgroundActionQueue.queueTask(this.upgradeTaskAsync);
        this.templateDao.resetCache();
        this.attributeDao.resetCache();
        log.info("End Bandana to ActiveObjects upgradeTask 1");
    }
}

