/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.framework;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import com.cenotelabs.lockpoint.framework.LockpointServletActionContext;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.stereotype.Component;

@Component
public class DeferredMessageManager {
    private LockpointServletActionContext lockpointServletActionContext;
    private String SESSION_KEY_LOCKPOINT_ERRORS = "lockpoint.errors";
    private String SESSION_KEY_LOCKPOINT_NOTE = "lockpoint.warnings";

    public DeferredMessageManager(LockpointServletActionContext lockpointServletActionContext) {
        this.lockpointServletActionContext = lockpointServletActionContext;
    }

    private HttpSession getSession() {
        HttpServletRequest httpServletRequest = this.lockpointServletActionContext.getRequest();
        if (httpServletRequest != null) {
            return httpServletRequest.getSession();
        }
        return null;
    }

    private List<String> getAndClearDeferredMessages(String string) {
        HttpSession httpSession = this.getSession();
        List<String> list = new ArrayList<String>();
        if (httpSession != null) {
            Object object = httpSession.getAttribute(string);
            if (object instanceof List) {
                list = (List)object;
            }
            httpSession.setAttribute(string, new ArrayList());
        }
        return list;
    }

    public List<String> getAndClearDeferredErrors() {
        DeferredMessageManager deferredMessageManager = this;
        return deferredMessageManager.getAndClearDeferredMessages(deferredMessageManager.SESSION_KEY_LOCKPOINT_ERRORS);
    }

    public List<String> getAndClearDeferredNotes() {
        DeferredMessageManager deferredMessageManager = this;
        return deferredMessageManager.getAndClearDeferredMessages(deferredMessageManager.SESSION_KEY_LOCKPOINT_NOTE);
    }

    private void addDeferredMessage(String object, String string) {
        HttpSession httpSession = this.getSession();
        if (httpSession != null) {
            ArrayList arrayList = httpSession.getAttribute((String)object);
            if (arrayList == null || !(arrayList instanceof List)) {
                arrayList = new ArrayList();
                httpSession.setAttribute((String)object, arrayList);
            }
            object = arrayList;
            object.add(string);
        }
    }

    public void addDeferredError(String string, Object ... objectArray) {
        DeferredMessageManager deferredMessageManager = this;
        deferredMessageManager.addDeferredMessage(deferredMessageManager.SESSION_KEY_LOCKPOINT_ERRORS, ConfluenceActionSupport.getTextStatic((String)string, (Object[])PlainTextToHtmlConverter.encodeHtmlEntities((Object[])objectArray)));
    }

    public void addDeferredNote(String string, Object ... objectArray) {
        DeferredMessageManager deferredMessageManager = this;
        deferredMessageManager.addDeferredMessage(deferredMessageManager.SESSION_KEY_LOCKPOINT_NOTE, ConfluenceActionSupport.getTextStatic((String)string, (Object[])PlainTextToHtmlConverter.encodeHtmlEntities((Object[])objectArray)));
    }
}

