/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.bandana.upgrade;

import com.arsenale.plugins.lockpoint.model.CheckoutPermissionsBandanaData;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.cenotelabs.lockpoint.F;
import com.cenotelabs.lockpoint.I;
import com.cenotelabs.lockpoint.background.BackgroundActionQueue;
import com.cenotelabs.lockpoint.bandana.LockpointBandanaManager;
import com.cenotelabs.lockpoint.cluster.ClusterHelper;
import com.cenotelabs.lockpoint.h;
import com.cenotelabs.lockpoint.k;
import com.cenotelabs.lockpoint.n;
import com.cenotelabs.lockpoint.util.LockpointUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class LockpointUserUpgradeTaskV1
implements PluginUpgradeTask,
k {
    private static final Logger log = LoggerFactory.getLogger(LockpointUserUpgradeTaskV1.class);
    private static final int BUILD_NUMBER = 1;
    private SpaceManager spaceManager;
    private LockpointBandanaManager lockpointBandanaManager;
    private BackgroundActionQueue backgroundActionQueue;
    private TransactionTemplate transactionTemplate;
    private ClusterHelper clusterHelper;

    @Inject
    public LockpointUserUpgradeTaskV1(@ComponentImport SpaceManager spaceManager, LockpointBandanaManager lockpointBandanaManager, BackgroundActionQueue backgroundActionQueue, @ComponentImport TransactionTemplate transactionTemplate, ClusterHelper clusterHelper) {
        this.spaceManager = spaceManager;
        this.lockpointBandanaManager = lockpointBandanaManager;
        this.backgroundActionQueue = backgroundActionQueue;
        this.transactionTemplate = transactionTemplate;
        this.clusterHelper = clusterHelper;
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "Migrates username property to userKey property";
    }

    private void migrateLockpointAdministratorsToUserKeys(Space space) {
        CheckoutPermissionsBandanaData checkoutPermissionsBandanaData = this.lockpointBandanaManager.get(space, "com.arsenale.plugins.lockpoint.spacepermissions", CheckoutPermissionsBandanaData.class);
        if (checkoutPermissionsBandanaData != null && checkoutPermissionsBandanaData.getUsers() != null && checkoutPermissionsBandanaData.getUsers().size() > 0) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : checkoutPermissionsBandanaData.getUsers()) {
                String string2 = LockpointUtil.getStringKeyForUsername(string);
                if (string2 == null) {
                    log.error("Lockpoint could not migrate data for username " + string + " because that user could no longer be found");
                    arrayList.add(string);
                    continue;
                }
                arrayList.add(string2);
            }
            checkoutPermissionsBandanaData.setUsers(arrayList);
            this.lockpointBandanaManager.set(space, "com.arsenale.plugins.lockpoint.spacepermissions", CheckoutPermissionsBandanaData.class, checkoutPermissionsBandanaData);
        }
    }

    public Collection<Message> doUpgrade() {
        this.backgroundActionQueue.queueTask(this);
        return Collections.emptySet();
    }

    @Override
    public void runAsync() {
        n n2 = this.clusterHelper.obtainClusterLock(this.getClass().getName() + ":upgradeUserKeys");
        try {
            try (F f2 = I.a("upgradeUserKeys");){
                this.upgradeUserKeysSynchronized();
            }
            return;
        }
        finally {
            n2.a();
        }
    }

    private void upgradeUserKeysSynchronized() {
        Object object = this.spaceManager.getAllSpaces();
        log.info("Begin upgrading Cenote Lockpoint usernames to user keys");
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            Space space = (Space)object.next();
            if (++n2 % 100 == 0) {
                log.debug("Processed {} spaces", (Object)n2);
            }
            this.transactionTemplate.execute(() -> {
                h.b(space);
                this.migrateLockpointAdministratorsToUserKeys(space);
                return null;
            });
        }
        log.info("Finished upgrading Cenote Lockpoint usernames to user keys");
    }

    public String getPluginKey() {
        return "com.arsenale.plugins.lockpoint";
    }
}

