/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.activeobjects;

import com.arsenale.plugins.lockpoint.model.GlobalPluginData;
import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.cenotelabs.lockpoint.activeobjects.daos.AttributeDao;
import com.cenotelabs.lockpoint.activeobjects.daos.TemplateDao;
import com.cenotelabs.lockpoint.activeobjects.models.Attribute;
import com.cenotelabs.lockpoint.activeobjects.models.Template;
import com.cenotelabs.lockpoint.attdao.IntAttachmentRealm;
import com.cenotelabs.lockpoint.bandana.LockpointBandanaManager;
import com.cenotelabs.lockpoint.k;
import com.cenotelabs.lockpoint.model.Timeouts;
import com.cenotelabs.lockpoint.settings.LegacySpaceAttributesManager;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AoUpgradeAsyncTask1
implements k {
    private static final Logger a = LoggerFactory.getLogger(AoUpgradeAsyncTask1.class);
    private final SpaceManager b;
    private final TransactionTemplate c;
    private final LockpointBandanaManager d;
    private final LegacySpaceAttributesManager e;
    private final TemplateDao f;
    private final AttributeDao g;
    private final ActiveObjects h;

    @Inject
    public AoUpgradeAsyncTask1(@ComponentImport SpaceManager spaceManager, @ComponentImport TransactionTemplate transactionTemplate, LockpointBandanaManager lockpointBandanaManager, LegacySpaceAttributesManager legacySpaceAttributesManager, TemplateDao templateDao, AttributeDao attributeDao, ActiveObjects activeObjects) {
        this.b = spaceManager;
        this.c = transactionTemplate;
        this.d = lockpointBandanaManager;
        this.e = legacySpaceAttributesManager;
        this.f = templateDao;
        this.g = attributeDao;
        this.h = activeObjects;
    }

    @Override
    public void runAsync() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            Thread.interrupted();
        }
        this.a();
    }

    private void a() {
        a.info("Begin Task 1 Lockpoint Bandana to ActiveObjects migration");
        this.c.execute(() -> {
            GlobalPluginData globalPluginData = this.d.get(null, "com.arsenale.plugins.lockpoint.GlobalPluginData", GlobalPluginData.class);
            boolean bl = globalPluginData != null ? globalPluginData.getDefaultSpaceEnabled() : true;
            this.g.save(this.h, new Attribute(null, Attribute.Type.LOCKPOINT_ENABLED, bl));
            return null;
        });
        Object object = this.b.getAllSpaces();
        int n2 = 0;
        int n3 = object.size();
        object = object.iterator();
        while (object.hasNext()) {
            Space space = (Space)object.next();
            a.debug("Task 1: Performing one-time Lockpoint ActiveObjects data migration for space {} ({}/{})", new Object[]{space.getKey(), ++n2, n3});
            this.c.execute(() -> {
                boolean bl;
                Boolean bl2 = this.e.isLockpointEnabledInSpaceWithNullForDefault(space);
                if (bl2 != null) {
                    this.g.save(this.h, new Attribute(space, Attribute.Type.LOCKPOINT_ENABLED, bl2));
                }
                boolean bl3 = this.e.hasCustomizedWarningTimeout(space, IntAttachmentRealm.a);
                boolean bl4 = this.e.hasCustomizedUnlockTimeout(space, IntAttachmentRealm.a);
                if (bl3 || bl4) {
                    Timeouts timeouts = this.e.getWarningTimeoutsForSpace(space);
                    Timeouts timeouts2 = this.e.getUnlockTimeoutsForSpace(space);
                    this.g.save(this.h, new Attribute(space, Attribute.Type.WARNING_TIMEOUT, timeouts.getNormalTimeout()));
                    this.g.save(this.h, new Attribute(space, Attribute.Type.UNLOCK_TIMEOUT, timeouts2.getNormalTimeout()));
                }
                if (bl = this.e.hasWarningSubject(space) || this.e.hasWarningBody(space)) {
                    this.f.save(this.h, new Template(space, Template.Format.TEXT, Template.Type.WARNING, null, this.e.getRawWarningSubject(space), this.e.getRawWarningBody(space)));
                }
                if (bl4 = this.e.hasUnlockSubject(space) || this.e.hasUnlockBody(space)) {
                    this.f.save(this.h, new Template(space, Template.Format.TEXT, Template.Type.UNLOCK, null, this.e.getRawUnlockSubject(space), this.e.getRawUnlockBody(space)));
                }
                if (bl = this.e.hasNotifyBody(space) || this.e.hasNotifySubject(space)) {
                    this.f.save(this.h, new Template(space, Template.Format.TEXT, Template.Type.NOTIFY, null, this.e.getRawNotifySubject(space), this.e.getRawNotifyBody(space)));
                }
                return null;
            });
        }
        this.f.resetCache();
        this.g.resetCache();
        a.info("End Task 1 Lockpoint Bandana to ActiveObjects migration");
    }
}

