/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.activeobjects;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.cenotelabs.lockpoint.activeobjects.AoUpgradeAsyncTask2;
import com.cenotelabs.lockpoint.activeobjects.daos.ConfigDao;
import com.cenotelabs.lockpoint.activeobjects.daos.LockDao;
import com.cenotelabs.lockpoint.activeobjects.daos.PermissionDao;
import com.cenotelabs.lockpoint.activeobjects.entities.AttrEntity;
import com.cenotelabs.lockpoint.activeobjects.entities.ConfigEntity;
import com.cenotelabs.lockpoint.activeobjects.entities.LockEntity;
import com.cenotelabs.lockpoint.activeobjects.entities.PermissionEntity;
import com.cenotelabs.lockpoint.activeobjects.entities.TemplateEntity;
import com.cenotelabs.lockpoint.background.BackgroundActionQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AoUpgradeTask2
implements ActiveObjectsUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(AoUpgradeTask2.class);
    public static final ModelVersion CURRENT_VERSION = ModelVersion.valueOf((String)"2");
    private final LockDao lockDao;
    private final ConfigDao configDao;
    private final PermissionDao permissionDao;
    private final BackgroundActionQueue backgroundActionQueue;
    private final AoUpgradeAsyncTask2 upgradeTaskAsync;

    public AoUpgradeTask2(LockDao lockDao, ConfigDao configDao, PermissionDao permissionDao, BackgroundActionQueue backgroundActionQueue, AoUpgradeAsyncTask2 aoUpgradeAsyncTask2) {
        this.lockDao = lockDao;
        this.configDao = configDao;
        this.permissionDao = permissionDao;
        this.backgroundActionQueue = backgroundActionQueue;
        this.upgradeTaskAsync = aoUpgradeAsyncTask2;
    }

    public ModelVersion getModelVersion() {
        return CURRENT_VERSION;
    }

    public void upgrade(ModelVersion modelVersion, ActiveObjects activeObjects) {
        try {
            if (modelVersion.isOlderThan(CURRENT_VERSION)) {
                this.convertFromBandana(activeObjects);
            }
            return;
        }
        catch (Throwable throwable) {
            log.error("Could not perform ActiveObjects upgrade", throwable);
            return;
        }
    }

    private void convertFromBandana(ActiveObjects activeObjects) {
        log.info("Begin Bandana to ActiveObjects upgradeTask 2");
        activeObjects.migrate(new Class[]{AttrEntity.class, TemplateEntity.class, LockEntity.class, ConfigEntity.class, PermissionEntity.class});
        log.info("Task 2 entities created; queueing background thread to perform upgrade");
        this.backgroundActionQueue.queueTask(this.upgradeTaskAsync);
        this.lockDao.resetCache();
        this.configDao.resetCache();
        this.permissionDao.resetCache();
        log.info("End Bandana to ActiveObjects upgradeTask 2");
    }
}

