/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.struts.interceptors;

import com.cenotelabs.lockpoint.struts.interceptors.SafeAroundInteceptor;
import com.cenotelabs.lockpoint.velocity.ReplacementRepo;
import com.cenotelabs.lockpoint.velocity.srl.StringResourceLoaderInstaller;
import com.cenotelabs.lockpoint.velocity.srl.StringResourceLoaderRemapper;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.entities.ResultConfig;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.views.velocity.VelocityManager;
import org.apache.velocity.app.VelocityEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockpointVelocityInterceptor
extends SafeAroundInteceptor {
    private static final Logger a = LoggerFactory.getLogger(LockpointVelocityInterceptor.class);
    private final StringResourceLoaderInstaller srlInstaller;
    private final StringResourceLoaderRemapper srlRemapper;
    private final ReplacementRepo replacementRepo;

    @Inject
    public LockpointVelocityInterceptor(StringResourceLoaderInstaller stringResourceLoaderInstaller, StringResourceLoaderRemapper stringResourceLoaderRemapper, ReplacementRepo replacementRepo) {
        this.srlInstaller = stringResourceLoaderInstaller;
        this.srlRemapper = stringResourceLoaderRemapper;
        this.replacementRepo = replacementRepo;
    }

    public void init() {
    }

    @Override
    public void before(ActionInvocation actionInvocation) {
        VelocityManager velocityManager = (VelocityManager)actionInvocation.getInvocationContext().getInstance(VelocityManager.class);
        if (velocityManager.getVelocityEngine() == null) {
            a.debug("Setting up Velocity context");
            ServletContext servletContext = ServletActionContext.getServletContext();
            velocityManager.init(servletContext);
        }
        boolean bl = false;
        if ((velocityManager = velocityManager.getVelocityEngine()) == null) {
            a.warn("No VelocityEngine found - could not install SRL");
        } else if (!this.srlInstaller.isInstalled((VelocityEngine)velocityManager)) {
            this.srlInstaller.installVelocityResourceLoader((VelocityEngine)velocityManager);
            bl = true;
        }
        if (LockpointVelocityInterceptor.a(actionInvocation) && !this.srlInstaller.isInstalled((VelocityEngine)(actionInvocation = this.srlInstaller.getThreadLocalVelocityEngine())) && this.srlInstaller.installVelocityResourceLoaderUsingThreadLocal()) {
            this.srlInstaller.installVelocityResourceLoader((VelocityEngine)actionInvocation);
            bl = true;
        }
        if (bl) {
            this.replacementRepo.applyReplacementsToVelocity(this.srlRemapper);
        }
    }

    private static boolean a(ActionInvocation object) {
        object = object.getProxy().getConfig().getResults();
        return object.entrySet().stream().anyMatch(entry -> ((ResultConfig)entry.getValue()).getClassName().contains("Velocity"));
    }

    public void destroy() {
        this.srlInstaller.removeVelocityResourceLoaderUsingThreadLocal();
    }
}

