/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.settings;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.cenotelabs.lockpoint.activeobjects.models.CustomizableTemplate;
import com.cenotelabs.lockpoint.activeobjects.models.Template;
import com.cenotelabs.lockpoint.activeobjects.models.Timeout;
import com.cenotelabs.lockpoint.activeobjects.services.AttributeService;
import com.cenotelabs.lockpoint.activeobjects.services.TemplateService;
import com.cenotelabs.lockpoint.activeobjects.services.TimeoutService;
import com.cenotelabs.lockpoint.i18n.LanguageHelper;
import com.cenotelabs.lockpoint.model.EmailTemplate;
import com.cenotelabs.lockpoint.rest.transport.SpaceTemplatesTransport;
import com.cenotelabs.lockpoint.rest.transport.SpaceTimeoutsTransport;
import com.cenotelabs.lockpoint.settings.SpaceAttributesManager;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component(value="spaceAttributesManager")
public class DefaultSpaceAttributesManager
implements SpaceAttributesManager {
    private AttributeService a;
    private TemplateService b;
    private TimeoutService c;
    private LanguageHelper d;

    @Inject
    public DefaultSpaceAttributesManager(AttributeService attributeService, TemplateService templateService, TimeoutService timeoutService, LanguageHelper languageHelper) {
        this.a = attributeService;
        this.b = templateService;
        this.c = timeoutService;
        this.d = languageHelper;
    }

    @Override
    public Boolean getLockpointEnabled(Space space) {
        return this.a.getLockpointEnabled(space);
    }

    @Override
    public void setLockpointEnabled(Space space, Boolean bl) {
        if (space == null && bl == null) {
            throw new IllegalArgumentException("Cannot set tristate value for system-wide space enablement");
        }
        this.a.setLockpointEnabled(space, bl);
    }

    @Override
    public boolean getDefaultLockpointEnabled() {
        return this.a.getLockpointEnabledDefault();
    }

    @Override
    public void setDefaultLockpointEnabled(boolean bl) {
        this.a.setLockpointEnabledDefault(bl);
    }

    @Override
    public boolean isLockpointEnabledInSpace(Space object) {
        return (Boolean)((object = this.a.getLockpointEnabled((Space)object)) != null ? object : this.a.getLockpointEnabledDefault());
    }

    @Override
    public boolean isLockpointEnabledInSpace(ContentEntityObject contentEntityObject) {
        return contentEntityObject instanceof AbstractPage && this.isLockpointEnabledInSpace(((AbstractPage)contentEntityObject).getSpace());
    }

    @Override
    public boolean isLockpointEnabledInSpace(Attachment attachment) {
        return attachment != null && this.isLockpointEnabledInSpace(attachment.getContainer());
    }

    @Override
    public SpaceTimeoutsTransport getTimeoutsForSpace(Space object) {
        object = this.c.get((Space)object);
        Timeout timeout = this.c.getDefault();
        timeout = object != null ? object : timeout;
        return new SpaceTimeoutsTransport(timeout.getWarningTimeout(), timeout.getUnlockTimeout(), object == null);
    }

    @Override
    public SpaceTimeoutsTransport getDefaultTimeouts() {
        Timeout timeout = this.c.getDefault();
        return new SpaceTimeoutsTransport(timeout.getWarningTimeout(), timeout.getUnlockTimeout(), true);
    }

    @Override
    public void setTimeoutsForSpace(Space space, SpaceTimeoutsTransport spaceTimeoutsTransport) {
        if (space != null && spaceTimeoutsTransport.isUseSystemDefaults()) {
            this.c.remove(space);
            return;
        }
        this.c.set(new Timeout(space, spaceTimeoutsTransport.getWarningTimeout(), spaceTimeoutsTransport.getUnlockTimeout()));
    }

    @Override
    public void setDefaultTimeouts(SpaceTimeoutsTransport spaceTimeoutsTransport) {
        this.setTimeoutsForSpace(null, spaceTimeoutsTransport);
    }

    @Override
    public SpaceTemplatesTransport getTemplatesForSpace(Space space, ConfluenceUser confluenceUser) {
        return this.getTemplatesForSpace(space, this.d.getLanguageTagForUser(confluenceUser));
    }

    @Override
    public EmailTemplate getDefaultTemplate(String string, Template.Type type) {
        if (string.equals("GLOBAL")) {
            throw new IllegalArgumentException("Cannot fetch template of type " + (Object)((Object)type) + " for global language");
        }
        return this.getTemplateForSpace(null, type, string);
    }

    @Override
    public EmailTemplate getTemplateForSpace(Space space, Template.Type type, ConfluenceUser confluenceUser) {
        return this.getTemplateForSpace(space, type, this.d.getLanguageTagForUser(confluenceUser));
    }

    @Override
    public EmailTemplate getTemplateForSpace(@Nullable Space space, Template.Type object, String string) {
        boolean bl = true;
        Template template = null;
        if (space != null) {
            template = this.b.get(space, (Template.Type)((Object)object), null);
        }
        if (template == null) {
            object = this.b.getDefault((Template.Type)((Object)object), string);
            template = ((CustomizableTemplate)object).getTemplate();
            bl = space == null && ((CustomizableTemplate)object).isCustomized();
        }
        return new EmailTemplate(template, bl);
    }

    @Override
    public SpaceTemplatesTransport getTemplatesForSpace(Space object, String string) {
        EmailTemplate emailTemplate = this.getTemplateForSpace((Space)object, Template.Type.WARNING, string);
        EmailTemplate emailTemplate2 = this.getTemplateForSpace((Space)object, Template.Type.UNLOCK, string);
        object = this.getTemplateForSpace((Space)object, Template.Type.NOTIFY, string);
        return new SpaceTemplatesTransport(emailTemplate, emailTemplate2, (EmailTemplate)object);
    }

    @Override
    public void setTemplatesForSpace(@Nonnull Space space, SpaceTemplatesTransport spaceTemplatesTransport) {
        this.a(space, Template.Type.WARNING, null, spaceTemplatesTransport.getWarning(), spaceTemplatesTransport.getWarning().isCustomized());
        this.a(space, Template.Type.UNLOCK, null, spaceTemplatesTransport.getUnlock(), spaceTemplatesTransport.getUnlock().isCustomized());
        this.a(space, Template.Type.NOTIFY, null, spaceTemplatesTransport.getNotify(), spaceTemplatesTransport.getNotify().isCustomized());
    }

    private List<String> a(String string) {
        if (!string.equals("GLOBAL")) {
            return Collections.singletonList(string);
        }
        return this.d.getSupportedLanguageKeys();
    }

    @Override
    public void setDefaultTemplate(String object, Template.Type type, EmailTemplate emailTemplate) {
        for (String string : this.a((String)object)) {
            this.a(null, type, string, emailTemplate, true);
        }
    }

    @Override
    public void revertDefaultTemplate(String object, Template.Type type) {
        for (String string : this.a((String)object)) {
            this.a(null, type, string, null, false);
        }
    }

    private void a(Space space, Template.Type type, String string, EmailTemplate emailTemplate, boolean bl) {
        if (bl) {
            this.b.set(new Template(space, Template.Format.TEXT, type, string, emailTemplate.getSubject(), emailTemplate.getBody()));
            return;
        }
        this.b.remove(space, type, string);
    }
}

