/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.rest;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.cenotelabs.lockpoint.rest.RestUtil;
import com.cenotelabs.lockpoint.rest.transport.RestResult;
import com.cenotelabs.lockpoint.util.LockpointUtil;
import java.io.Serializable;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

public abstract class SpaceAwareRestResource {
    private LockpointUtil lockpointUtil;
    private SpaceManager spaceManager;
    private I18nResolver i18nResolver;
    private PermissionManager permissionManager;

    SpaceAwareRestResource(LockpointUtil lockpointUtil, SpaceManager spaceManager, I18nResolver i18nResolver, PermissionManager permissionManager) {
        this.lockpointUtil = lockpointUtil;
        this.spaceManager = spaceManager;
        this.i18nResolver = i18nResolver;
        this.permissionManager = permissionManager;
    }

    public I18nResolver getI18nResolver() {
        return this.i18nResolver;
    }

    private void verifyLockpointAdminPermissions(Space space, boolean bl) {
        if (!this.isLockpointAdmin(space)) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new RestResult(RestUtil.getErrorTitle(this.i18nResolver, bl), this.i18nResolver.getText("com.arsenale.plugins.lockpoint.noPermissionForAction"))).build());
        }
    }

    void verifyLockpointAdminPermissionsForReading(Space space) {
        this.verifyLockpointAdminPermissions(space, false);
    }

    void verifyLockpointAdminPermissionsForWriting(Space space) {
        this.verifyLockpointAdminPermissions(space, true);
    }

    private void verifySpaceAdminPermissions(Space space, boolean bl) {
        if (!this.isSpaceAdmin(space)) {
            RestUtil.throwNoAccessError(this.i18nResolver, bl);
        }
    }

    void verifySpaceAdminPermissionsForReading(Space space) {
        this.verifySpaceAdminPermissions(space, false);
    }

    void verifySpaceAdminPermissionsForWriting(Space space) {
        this.verifySpaceAdminPermissions(space, true);
    }

    private Response badSpaceResponse(String string, boolean bl) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)new RestResult(RestUtil.getErrorTitle(this.i18nResolver, bl), this.i18nResolver.getText("com.arsenale.plugins.lockpoint.xwork.actions.EditSpaceConfigurationAction.spaceNotFound", new Serializable[]{string}))).build();
    }

    private Space verifySpace(String string, boolean bl) {
        Space space = this.spaceManager.getSpace(string);
        if (space == null) {
            throw new WebApplicationException(this.badSpaceResponse(string, bl));
        }
        return space;
    }

    Space verifySpaceForReading(String string) {
        return this.verifySpace(string, false);
    }

    Space verifySpaceForWriting(String string) {
        return this.verifySpace(string, true);
    }

    public boolean isLockpointAdmin(Space space) {
        return this.lockpointUtil.isLockpointAdministrator(AuthenticatedUserThreadLocal.get(), space);
    }

    public boolean isSpaceAdmin(Space space) {
        return this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.ADMINISTER, (Object)space);
    }

    public LockpointUtil getLockpointUtil() {
        return this.lockpointUtil;
    }
}

