/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.bandana.upgrade;

import com.arsenale.plugins.lockpoint.model.EmailReminderBandanaData;
import com.arsenale.plugins.lockpoint.model.EmailTemplateBandanaData;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.cenotelabs.lockpoint.E;
import com.cenotelabs.lockpoint.H;
import com.cenotelabs.lockpoint.attdao.IntAttachmentRealm;
import com.cenotelabs.lockpoint.background.BackgroundActionQueue;
import com.cenotelabs.lockpoint.bandana.LockpointBandanaManager;
import com.cenotelabs.lockpoint.cluster.ClusterHelper;
import com.cenotelabs.lockpoint.k;
import com.cenotelabs.lockpoint.model.EmailTemplate;
import com.cenotelabs.lockpoint.n;
import com.cenotelabs.lockpoint.settings.LegacySpaceAttributesManager;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class Lockpoint165UpgradeTaskV2
implements PluginUpgradeTask,
k {
    private static final Logger log = LoggerFactory.getLogger(Lockpoint165UpgradeTaskV2.class);
    private static final int BUILD_NUMBER = 2;
    private ClusterHelper clusterHelper;
    private TransactionTemplate transactionTemplate;
    private SpaceManager spaceManager;
    private LockpointBandanaManager bandanaManager;
    private LegacySpaceAttributesManager legacySam;
    private BackgroundActionQueue backgroundActionQueue;

    @Inject
    public Lockpoint165UpgradeTaskV2(ClusterHelper clusterHelper, @ComponentImport TransactionTemplate transactionTemplate, @ComponentImport SpaceManager spaceManager, LockpointBandanaManager lockpointBandanaManager, LegacySpaceAttributesManager legacySpaceAttributesManager, BackgroundActionQueue backgroundActionQueue) {
        this.clusterHelper = clusterHelper;
        this.transactionTemplate = transactionTemplate;
        this.spaceManager = spaceManager;
        this.bandanaManager = lockpointBandanaManager;
        this.legacySam = legacySpaceAttributesManager;
        this.backgroundActionQueue = backgroundActionQueue;
    }

    public int getBuildNumber() {
        return 2;
    }

    public String getShortDescription() {
        return "Migrates Lockpoint <=1.6.5 data";
    }

    public String getPluginKey() {
        return "com.arsenale.plugins.lockpoint";
    }

    public Collection<Message> doUpgrade() {
        this.backgroundActionQueue.queueTask(this);
        return Collections.emptyList();
    }

    @Override
    public void runAsync() {
        log.debug("Performing upgrade of Lockpoint <= 1.6.5 data");
        n n2 = this.clusterHelper.obtainClusterLock(this.getClass().getName() + ":upgradeFromLockpoint165");
        try {
            try (E e2 = H.a("upgradeFromLockpoint165");){
                this.upgradeFromLockpoint165Synchronized();
            }
            return;
        }
        finally {
            n2.a();
        }
    }

    private void upgradeFromLockpoint165Synchronized() {
        Object object;
        log.debug("Getting space list");
        try (E e2 = H.a("[upgrade] getSpaceList");){
            object = this.spaceManager.getAllSpaces();
        }
        log.debug("Iterating through spaces");
        int n2 = 0;
        try (E e3 = H.a("[upgrade] processAllSpaces");){
            object = object.iterator();
            while (object.hasNext()) {
                Space space = (Space)object.next();
                if (++n2 % 100 == 0) {
                    log.debug("Processed {} spaces", (Object)n2);
                }
                this.transactionTemplate.execute(() -> {
                    Serializable serializable = this.bandanaManager.get(space, "com.arsenale.plugins.lockpoint.EmailReminderScheme", EmailReminderBandanaData.class);
                    if (serializable != null) {
                        log.info("Migrating email reminder data for space {}", (Object)space.getKey());
                        EmailTemplateBandanaData emailTemplateBandanaData = ((EmailReminderBandanaData)serializable).getWarningTemplate();
                        EmailTemplateBandanaData emailTemplateBandanaData2 = ((EmailReminderBandanaData)serializable).getForcedCheckinTemplate();
                        serializable = ((EmailReminderBandanaData)serializable).getNotifyTemplate();
                        if (!emailTemplateBandanaData.getUseSystemDefault()) {
                            this.legacySam.setWarningTimeoutForSpace(space, IntAttachmentRealm.a, emailTemplateBandanaData.getNormalHours());
                            this.legacySam.setWarningTimeoutForSpace(space, IntAttachmentRealm.b, emailTemplateBandanaData.getWebdavHours());
                            this.legacySam.setWarningTemplate(space, new EmailTemplate(true, emailTemplateBandanaData.getSubject(), emailTemplateBandanaData.getBodyText()));
                        }
                        if (!emailTemplateBandanaData2.getUseSystemDefault()) {
                            this.legacySam.setUnlockTimeoutForSpace(space, IntAttachmentRealm.a, emailTemplateBandanaData2.getNormalHours());
                            this.legacySam.setUnlockTimeoutForSpace(space, IntAttachmentRealm.b, emailTemplateBandanaData2.getWebdavHours());
                            this.legacySam.setUnlockTemplate(space, new EmailTemplate(true, emailTemplateBandanaData2.getSubject(), emailTemplateBandanaData2.getBodyText()));
                        }
                        if (!((EmailTemplateBandanaData)serializable).getUseSystemDefault()) {
                            this.legacySam.setNotifyTemplate(space, new EmailTemplate(true, ((EmailTemplateBandanaData)serializable).getSubject(), ((EmailTemplateBandanaData)serializable).getBodyText()));
                        }
                        this.bandanaManager.remove(space, "com.arsenale.plugins.lockpoint.EmailReminderScheme");
                    }
                    return null;
                });
            }
        }
        log.debug("Finished possible upgrade");
    }
}

