/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.activeobjects.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.cenotelabs.lockpoint.E;
import com.cenotelabs.lockpoint.H;
import com.cenotelabs.lockpoint.activeobjects.daos.LockDao;
import com.cenotelabs.lockpoint.activeobjects.exceptions.LockpointAttachmentNotFoundException;
import com.cenotelabs.lockpoint.activeobjects.models.LockModel;
import com.cenotelabs.lockpoint.e;
import com.cenotelabs.lockpoint.r;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LockService {
    private final LockDao b;
    private final ActiveObjects c;
    private final AttachmentManager d;
    public static String a;

    @Inject
    public LockService(LockDao lockDao, ActiveObjects activeObjects, AttachmentManager attachmentManager) {
        this.b = lockDao;
        this.c = activeObjects;
        this.d = attachmentManager;
    }

    @Nonnull
    public r getLock(long l2) {
        try (E e2 = H.a("LockService#getLockById");){
            Attachment attachment;
            try (Object object = H.a("LockService#getLockById-getAttachment");){
                attachment = this.d.getAttachment(l2);
            }
            if (attachment == null) {
                throw new LockpointAttachmentNotFoundException("Cannot find attachmentId " + l2);
            }
            object = this.getLock(attachment);
            return object;
        }
    }

    @Nonnull
    public r getLock(ContentEntityObject contentEntityObject, String string) {
        try (E e2 = H.a("LockService#getLockByFileName");){
            Attachment attachment;
            if (contentEntityObject == null) {
                throw new LockpointAttachmentNotFoundException("Cannot getLock() for a null ceo");
            }
            if (string == null) {
                throw new LockpointAttachmentNotFoundException("Cannot getLock() for a null filename");
            }
            try (Object object = H.a("LockService#getLockByFileName-getAttachment");){
                attachment = this.d.getAttachment(contentEntityObject, string);
            }
            if (attachment == null) {
                throw new LockpointAttachmentNotFoundException("Cannot find attachment named " + string + " on CEO " + contentEntityObject.getId());
            }
            object = this.getLock(attachment);
            return object;
        }
    }

    @Nonnull
    public r getLock(Attachment object) {
        try (E e2 = H.a("LockService#getLock");){
            Object object2;
            if (object == null) {
                throw new LockpointAttachmentNotFoundException("Cannot getLock() for a null attachment");
            }
            if (!object.isLatestVersion()) {
                object2 = object.getLatestVersion();
                if (!(object2 instanceof Attachment)) {
                    throw new IllegalStateException("The latest version of an attachment must be an attachment: " + object2);
                }
                object = (Attachment)object2;
            }
            if ((object2 = this.b.get(this.c, object.getId())) == null) {
                object2 = new LockModel(object.getId(), object.getSpace().getId());
            }
            object = new r((Attachment)object, (LockModel)object2);
            return object;
        }
    }

    private r a(LockModel lockModel) {
        Attachment attachment = this.d.getAttachment(lockModel.getAttachmentId());
        if (attachment != null) {
            return new r(attachment, lockModel);
        }
        return null;
    }

    public List<r> getLockedAttachmentsForSpace(Space object) {
        object = this.b.getInSpace(this.c, object.getId());
        return object.stream().map(this::a).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<r> getAllLocks() {
        try (E e2 = H.a("LockService#getAllLocks");){
            List<LockModel> list = this.b.getAll(this.c);
            List list2 = list.stream().map(this::a).filter(Objects::nonNull).sorted(e.a).collect(Collectors.toList());
            list = list2;
            return list;
        }
    }

    public void lock(r r2, ConfluenceUser object, boolean bl) {
        if (object == null) {
            throw new IllegalArgumentException("Anonymous users may not lock attachments");
        }
        object = object.getKey().getStringValue();
        this.lock(r2, (String)object, bl, System.currentTimeMillis());
    }

    public void lock(r r2, String string, boolean bl, long l2) {
        LockModel lockModel = r2.b();
        lockModel.setLocked(true);
        lockModel.setOwner(string);
        lockModel.setLockedDate(l2);
        lockModel.setLockedWithWebDav(bl);
        lockModel.setSpaceId(r2.e().getId());
        this.b.save(this.c, lockModel);
    }

    public void unlock(r r2) {
        long l2 = r2.c();
        Space space = r2.e();
        this.b.delete(this.c, r2.c());
        LockModel lockModel = new LockModel(l2, space.getId());
        r2.a(lockModel);
    }

    public void saveModel(LockModel lockModel) {
        this.b.save(this.c, lockModel);
    }

    public boolean getSentWarningMail(r r2) {
        return r2.b().isLocked() && r2.b().isSentWarningEmail();
    }

    public void setSentWarningMail(r r2, boolean bl) {
        if (!r2.b().isLocked()) {
            return;
        }
        LockModel lockModel = r2.b();
        lockModel.setSentWarningEmail(bl);
        lockModel.setSpaceId(r2.e().getId());
        this.b.save(this.c, lockModel);
    }

    public void addNotification(r r2, String string) {
        LockModel lockModel = r2.b();
        String string2 = lockModel.getNotifications();
        string2 = StringUtils.isBlank((String)string2) ? string : string2 + a + string;
        lockModel.setNotifications(string2);
        lockModel.setSpaceId(r2.e().getId());
        this.b.save(this.c, lockModel);
    }

    public boolean notificationListContains(r stringArray, String string) {
        stringArray = stringArray.b();
        if (StringUtils.isBlank((String)(stringArray = stringArray.getNotifications()))) {
            return false;
        }
        String[] stringArray2 = stringArray.split(a);
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n2 = stringArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = stringArray[i2];
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void removeNotification(r r2, String string) {
        LockModel lockModel = r2.b();
        Object object = lockModel.getNotifications();
        if (StringUtils.isBlank((String)object)) {
            return;
        }
        object = ((String)object).split(a);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : object) {
            if (string2.equals(string)) continue;
            arrayList.add(string2);
        }
        object = String.join((CharSequence)a, arrayList);
        lockModel.setNotifications((String)(((String)object).length() > 0 ? object : null));
        lockModel.setSpaceId(r2.e().getId());
        this.b.save(this.c, lockModel);
    }

    static {
        LoggerFactory.getLogger(LockService.class);
        a = ",";
    }
}

