/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.activeobjects.services;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.cenotelabs.lockpoint.activeobjects.daos.AttributeDao;
import com.cenotelabs.lockpoint.activeobjects.models.Attribute;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component
public class AttributeService {
    private ActiveObjects a;
    private AttributeDao b;

    @Inject
    public AttributeService(@ComponentImport ActiveObjects activeObjects, AttributeDao attributeDao) {
        this.a = activeObjects;
        this.b = attributeDao;
    }

    public Boolean getLockpointEnabled(Space object) {
        if ((object = this.b.get(this.a, (Space)object, Attribute.Type.LOCKPOINT_ENABLED)) != null) {
            return ((Attribute)object).getBoolValue();
        }
        return null;
    }

    public Boolean getLockpointEnabledDefault() {
        Attribute attribute = this.b.get(this.a, null, Attribute.Type.LOCKPOINT_ENABLED);
        return attribute != null ? attribute.getBoolValue() : true;
    }

    public void setLockpointEnabledDefault(boolean bl) {
        this.setLockpointEnabled(null, bl);
    }

    public void setLockpointEnabled(Space space, Boolean bl) {
        if (bl == null) {
            this.b.delete(this.a, space, Attribute.Type.LOCKPOINT_ENABLED);
            return;
        }
        this.b.save(this.a, new Attribute(space, Attribute.Type.LOCKPOINT_ENABLED, bl));
    }
}

