/*
 * Decompiled with CFR 0.152.
 */
package com.cenotelabs.lockpoint.activeobjects.daos;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.cache.CacheLoader;
import com.cenotelabs.lockpoint.E;
import com.cenotelabs.lockpoint.H;
import com.cenotelabs.lockpoint.a;
import com.cenotelabs.lockpoint.activeobjects.entities.LockEntity;
import com.cenotelabs.lockpoint.activeobjects.models.LockModel;
import com.cenotelabs.lockpoint.d;
import com.cenotelabs.lockpoint.f;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.java.ao.DBParam;
import org.springframework.stereotype.Component;

@Component
public class LockDao
extends a<LockEntity> {
    private static final int MAX_LOCK_CACHE_ENTRIES = 10000;
    private final LockEntity NULL_ENTITY = this.createNullEntity(LockEntity.class);

    public LockDao() {
        super(10000);
    }

    @Override
    protected LockEntity getNullEntity() {
        return this.NULL_ENTITY;
    }

    @Override
    public CacheLoader<String, LockEntity> getCacheLoader(ActiveObjects activeObjects) {
        return object2 -> {
            try (E e2 = H.a("LockDao#cacheLoader");){
                object2 = LockDao.cacheKeyToAttachmentId((String)object2);
                if (object2 == null) {
                    LockEntity lockEntity = this.NULL_ENTITY;
                    return lockEntity;
                }
                d d2 = this.getAttachmentIdQuery((Long)object2);
                ActiveObjects activeObjects = activeObjects;
                activeObjects = (LockEntity)this.enforceUnique(activeObjects, (LockEntity[])activeObjects.find(LockEntity.class, d2.a(), d2.b()));
                activeObjects = activeObjects == null ? this.NULL_ENTITY : activeObjects;
                return activeObjects;
            }
        };
    }

    private LockEntity getRaw(ActiveObjects object, long l2) {
        try (E e2 = H.a("LockDao#getRaw");){
            object = (LockEntity)this.getCache((ActiveObjects)object).get((Object)this.attachmentIdParamsToCacheKey(l2));
            Object object2 = object == this.NULL_ENTITY ? null : object;
            return object2;
        }
    }

    public LockModel get(ActiveObjects object, long l2) {
        if ((object = this.getRaw((ActiveObjects)object, l2)) != null) {
            return new LockModel((LockEntity)object);
        }
        return null;
    }

    public List<LockModel> getInSpace(ActiveObjects object, long l2) {
        try (E e2 = H.a("LockDao#getInSpace");){
            f f2 = this.getSpaceIdQuery(l2);
            object = (LockEntity[])object.find(LockEntity.class, f2.a(), f2.b());
            object = Arrays.stream(object).filter(Objects::nonNull).map(LockModel::new).collect(Collectors.toList());
            return object;
        }
    }

    public List<LockModel> getAll(ActiveObjects lockEntityArray) {
        try (E e2 = H.a("LockDao#getAll");){
            lockEntityArray = (LockEntity[])lockEntityArray.find(LockEntity.class);
            List<LockModel> list = Arrays.stream(lockEntityArray).filter(Objects::nonNull).map(LockModel::new).collect(Collectors.toList());
            return list;
        }
    }

    public void save(ActiveObjects activeObjects, LockModel lockModel) {
        if (!lockModel.isLocked()) {
            this.delete(activeObjects, lockModel.getAttachmentId());
            return;
        }
        try {
            LockEntity lockEntity = this.getRaw(activeObjects, lockModel.getAttachmentId());
            if (lockEntity != null) {
                lockEntity.setAttachmentId(lockModel.getAttachmentId());
                lockEntity.setSpaceId(lockModel.getSpaceId());
                lockEntity.setOwner(lockModel.getOwner());
                lockEntity.setLockedDate(lockModel.getLockedDate());
                lockEntity.setLockedWithWebDav(lockModel.isLockedWithWebDav());
                lockEntity.setSentWarningEmail(lockModel.isSentWarningEmail());
                lockEntity.setNotifications(lockModel.getNotifications());
                lockEntity.save();
                return;
            }
            lockEntity = (LockEntity)activeObjects.create(LockEntity.class, new DBParam[]{new DBParam("ATTACHMENT_ID", (Object)lockModel.getAttachmentId()), new DBParam("SPACE_ID", (Object)lockModel.getSpaceId()), new DBParam("OWNER", (Object)lockModel.getOwner()), new DBParam("LOCKED_DATE", (Object)lockModel.getLockedDate()), new DBParam("LOCKED_WITH_WEB_DAV", (Object)lockModel.isLockedWithWebDav()), new DBParam("SENT_WARNING_EMAIL", (Object)lockModel.isSentWarningEmail()), new DBParam("NOTIFICATIONS", (Object)lockModel.getNotifications())});
            lockEntity.save();
            return;
        }
        finally {
            this.invalidateCache(activeObjects, lockModel.getAttachmentId());
        }
    }

    public void delete(ActiveObjects activeObjects, long l2) {
        d d2 = this.getAttachmentIdQuery(l2);
        activeObjects.deleteWithSQL(LockEntity.class, d2.a(), d2.b());
        this.invalidateCache(activeObjects, l2);
    }

    private void invalidateCache(ActiveObjects activeObjects, long l2) {
        this.getCache(activeObjects).remove((Object)this.attachmentIdParamsToCacheKey(l2));
    }

    private String attachmentIdParamsToCacheKey(Long l2) {
        return Long.toString(l2);
    }
}

