/*
 * Copyright (c) 2017. GLiNTECH Pty Ltd.
 */

import ImmutableStore from "./ImmutableStore.js";
import AppDispatcher from "../dispatchers/AppDispatcher.js";
import BlogWatchersConstants from "../constants/BlogWatchersConstants.js";

class UserGroupStore extends ImmutableStore {

    constructor(props) {
        super(props);
        AppDispatcher.register(action => {
            switch (action.type) {
                case BlogWatchersConstants.ActionTypes.SEARCH_FOR_USER_GROUP:
                    this.search(action.data);
                    break;
                case BlogWatchersConstants.ActionTypes.SELECT_RESULT:
                    this._setSelectedResult(action.data);
                    break;
                case BlogWatchersConstants.ActionTypes.CLEAR:
                case BlogWatchersConstants.ActionTypes.CHOOSE_RESULT:
                    this._clear();
                    break;
            }
        })
    }

    getInitialData() {
        return {
            results: [],
            selectedResult: 0,
            visible: false
        };
    }

    search(query) {
        var contextPath = AJS.contextPath();
        var request = AJS.$.get(`${contextPath}/rest/prototype/1/search/user-or-group.json?max-results=10&query=${query}`);
        request.then(results => this._update(results));
    }

    _setSelectedResult(i) {
        var results = this.get('results');
        var resultCount = results.length - 1;
        if (i > resultCount) {
            i = resultCount;
        } else if (i < 0) {
            i = 0;
        }

        this.set("selectedResult", i);
    }

    _update(results) {
        this.set({
            visible: true,
            results: results.result,
            selectedResult: 0
        });
    }

    _clear() {
        this.set(this.getInitialData());
    }

    getSelectedResult() {
        return this.get("results")[this.get("selectedResult")];
    }

}

export default new UserGroupStore();