/*
 * Decompiled with CFR 0.152.
 */
package com.arijea.plugins.betterblogs.listeners;

import com.arijea.plugins.betterblogs.model.BlogWatchersModel;
import com.arijea.plugins.betterblogs.model.BlogWatchingGroupModel;
import com.arijea.plugins.betterblogs.model.BlogWatchingUserModel;
import com.arijea.plugins.betterblogs.rest.BlogWatchersResourceModel;
import com.arijea.plugins.betterblogs.service.BlogWatchersService;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.PaginatedMapping;
import com.atlassian.migration.app.gateway.AppCloudMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableListener;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class MigrationListenerImpl
implements DiscoverableListener {
    private static final Logger log = LoggerFactory.getLogger(MigrationListenerImpl.class);
    private final Gson gson = new Gson();
    private final BlogWatchersService blogWatchersService;
    @ConfluenceImport
    private final SpaceManager spaceManager;
    @ConfluenceImport
    private final UserAccessor userAccessor;

    @Inject
    public MigrationListenerImpl(BlogWatchersService blogWatchersService, SpaceManager spaceManager, UserAccessor userAccessor) {
        this.blogWatchersService = blogWatchersService;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
    }

    public void onStartAppMigration(AppCloudMigrationGateway gateway, String transferId, MigrationDetailsV1 migrationDetails) {
        try {
            log.warn("Migration context summary: " + this.gson.toJson((Object)migrationDetails));
            log.warn("Transfer Id: " + transferId);
            PaginatedMapping paginatedMapping = gateway.getPaginatedMapping(transferId, "confluence:space", 5000);
            HashMap mappings = new HashMap();
            while (paginatedMapping.next()) {
                Map pageMappings = paginatedMapping.getMapping();
                mappings.putAll(pageMappings);
            }
            int count = 0;
            int chunkSize = 0;
            int total = mappings.size() + 1;
            for (Map.Entry entry : mappings.entrySet()) {
                ++count;
                ++chunkSize;
                Space space = this.spaceManager.getSpace(Long.parseLong((String)entry.getKey()));
                BlogWatchersModel blogWatchersModel = this.blogWatchersService.getBlogWatchers(space.getKey());
                BlogWatchersResourceModel blogWatchersResourceModel = new BlogWatchersResourceModel();
                ArrayList<String> groups = new ArrayList<String>();
                ArrayList<String> users = new ArrayList<String>();
                for (BlogWatchingGroupModel groupModel : blogWatchersModel.getGroups()) {
                    groups.add(groupModel.getName());
                }
                for (BlogWatchingUserModel userModel : blogWatchersModel.getUsers()) {
                    String cloudId = this.getCloudIdOrNull(userModel.getUsername(), gateway, transferId);
                    if (cloudId == null) continue;
                    users.add(cloudId);
                }
                if (groups.size() <= 0 && users.size() <= 0) continue;
                blogWatchersResourceModel.setGroups(groups);
                blogWatchersResourceModel.setUsers(users);
                blogWatchersResourceModel.setSpaceKey(space.getKey());
                ObjectMapper mapper = new ObjectMapper();
                String jsonString = mapper.writeValueAsString((Object)blogWatchersResourceModel);
                int percent = (int)((float)(count + 1) / (float)total * 100.0f);
                String parseString = jsonString.substring(0, jsonString.length() - 1) + ",\"percent\":" + String.valueOf(percent) + ",\"total\": " + total + ",\"chunkSize\":" + chunkSize + "}";
                OutputStream firstDataStream = gateway.createAppData(transferId, "space-config");
                log.warn(parseString);
                firstDataStream.write(parseString.getBytes());
                firstDataStream.close();
                chunkSize = 0;
            }
            OutputStream firstDataStream = gateway.createAppData(transferId, "finished");
            String jsonString = "{\"total\": " + total + ",\"chunkSize\":" + (chunkSize + 1) + "}";
            firstDataStream.write(jsonString.getBytes());
            firstDataStream.close();
        }
        catch (Exception e) {
            log.error("Error while running the migration", (Throwable)e);
        }
    }

    public String getCloudAppKey() {
        return "better-blogs-for-confluence";
    }

    public String getServerAppKey() {
        return "com.arijea.plugins.betterblogs";
    }

    private String getCloudIdOrNull(String userName, AppCloudMigrationGateway gateway, String transferId) {
        try {
            ConfluenceUser user = this.userAccessor.getUserByName(userName);
            if (user != null) {
                String userKey = user.getKey().getStringValue();
                Map mappingById = gateway.getMappingById(transferId, "identity:user", Collections.singleton("confluence.userkey/" + userKey));
                String userId = (String)mappingById.get("confluence.userkey/" + userKey);
                return userId;
            }
        }
        catch (Exception e) {
            log.error("An exception occurred extracting the CloudId", (Object)e.getLocalizedMessage());
            throw e;
        }
        return null;
    }

    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_IDENTITY, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }
}

