/*
 * Copyright (c) 2017. GLiNTECH Pty Ltd.
 */

import React from "react";
import ReactDom from "react-dom";
import { throttle } from "lodash";

import UserGroupResultsList from "./UserGroupResultsList";
import {
    clear,
    chooseResult,
    searchForUserOrGroup,
    setSelectedResult,
} from "../../actions/BlogWatchersActions";
import UserGroupStore from "../../stores/UserGroupStore";

class UserGroupSelector extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            visible: false,
            results: [],
            selectedResult: 0,
        };
        this.throttledUpdate = throttle(this._request, 250, {
            leading: false,
        });
        this._onChange = this._onChange.bind(this);
    }

    getInitialState() {
        return this.getState();
    }

    componentDidMount() {
        UserGroupStore.addChangeListener(this._onChange);
        $(document).on("click", this._delayedClear);
    }

    componentWillUnmount() {
        this.throttledUpdate.cancel();
        this.throttledUpdate = null;
        UserGroupStore.removeChangeListener(this._onChange);
        $(document).off("click", this._delayedClear);
    }

    getState() {
        return UserGroupStore.getAll();
    }

    _onChange() {
        this.setState(this.getState());
    }

    render() {
        var style = {
            position: "relative",
        };

        return (
            <form className="aui" style={style} onSubmit={this._onSubmit.bind(this)}>
                <input
                    type="text"
                    ref="input"
                    id="blog-watcher-query"
                    placeholder="Search for users and groups"
                    className="text"
                    onKeyDown={this._onKeyUp.bind(this)}
                    onInput={this._onInput.bind(this)}
                    autoComplete="off"
                />
                <UserGroupResultsList
                    results={this.state.results}
                    visible={this.state.visible}
                    selectedResult={this.state.selectedResult}
                />
            </form>
        );
    }

    _request(query) {
        if (query && query.length > 1) {
            searchForUserOrGroup(query);
        } else {
            clear();
        }
    }

    _setSelectedResult(i) {
        setSelectedResult(i);
    }

    _onInput(e) {
        this.throttledUpdate(e.target.value);
    }

    _onSubmit(e) {
        e.preventDefault();
        chooseResult(UserGroupStore.getSelectedResult());
        ReactDom.findDOMNode(this.refs.input).value = "";
    }

    _clear() {
        clear();
    }

    _delayedClear() {
        setTimeout(() => this._clear, 1);
    }

    _onKeyUp(e) {
        switch (e.which) {
            case 40:
                e.preventDefault();
                this._setSelectedResult(this.state.selectedResult + 1);
                break;
            case 38:
                e.preventDefault();
                this._setSelectedResult(this.state.selectedResult - 1);
                break;
            case 27:
                this._clear();
                break;
        }
    }
}

export default UserGroupSelector;
